/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;

public class StatementLifecycleTest {
    @Test
    public void shouldReleaseStoreStatementOnlyWhenReferenceCountDownToZero() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = this.getKernelStatement(transaction, storageStatement);
        statement.acquire();
        ((StorageStatement)Mockito.verify((Object)storageStatement)).acquire();
        statement.acquire();
        statement.close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{storageStatement});
        statement.close();
        ((StorageStatement)Mockito.verify((Object)storageStatement)).release();
    }

    @Test
    public void shouldReleaseStoreStatementWhenForceClosingStatements() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        StorageStatement storageStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = this.getKernelStatement(transaction, storageStatement);
        statement.acquire();
        statement.forceClose();
        ((StorageStatement)Mockito.verify((Object)storageStatement)).release();
    }

    private KernelStatement getKernelStatement(KernelTransactionImplementation transaction, StorageStatement storageStatement) {
        return new KernelStatement(transaction, null, null, storageStatement, new Procedures());
    }
}

