/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.function.Supplier;
import org.junit.Before;
import org.mockito.Mockito;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHeaderInformation;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.api.store.StoreStatement;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StoreReadLayer;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.time.FakeClock;

public class KernelTransactionTestBase {
    protected final StorageEngine storageEngine = (StorageEngine)Mockito.mock(StorageEngine.class);
    protected final NeoStores neoStores = (NeoStores)Mockito.mock(NeoStores.class);
    protected final MetaDataStore metaDataStore = (MetaDataStore)Mockito.mock(MetaDataStore.class);
    protected final StoreReadLayer readLayer = (StoreReadLayer)Mockito.mock(StoreReadLayer.class);
    protected final TransactionHooks hooks = new TransactionHooks();
    protected final LegacyIndexTransactionState legacyIndexState = (LegacyIndexTransactionState)Mockito.mock(LegacyIndexTransactionState.class);
    protected final Supplier<LegacyIndexTransactionState> legacyIndexStateSupplier = () -> this.legacyIndexState;
    protected final TransactionMonitor transactionMonitor = (TransactionMonitor)Mockito.mock(TransactionMonitor.class);
    protected final CapturingCommitProcess commitProcess = new CapturingCommitProcess();
    protected final TransactionHeaderInformation headerInformation = (TransactionHeaderInformation)Mockito.mock(TransactionHeaderInformation.class);
    protected final TransactionHeaderInformationFactory headerInformationFactory = (TransactionHeaderInformationFactory)Mockito.mock(TransactionHeaderInformationFactory.class);
    protected final SchemaWriteGuard schemaWriteGuard = (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class);
    protected final FakeClock clock = new FakeClock();
    protected final Pool<KernelTransactionImplementation> txPool = (Pool)Mockito.mock(Pool.class);
    private final long defaultTransactionTimeoutMillis = (Long)GraphDatabaseSettings.transaction_timeout.from((Configuration)Config.defaults());

    @Before
    public void before() {
        Mockito.when((Object)this.headerInformation.getAdditionalHeader()).thenReturn((Object)new byte[0]);
        Mockito.when((Object)this.headerInformationFactory.create()).thenReturn((Object)this.headerInformation);
        Mockito.when((Object)this.readLayer.newStatement()).thenReturn(Mockito.mock(StoreStatement.class));
        Mockito.when((Object)this.neoStores.getMetaDataStore()).thenReturn((Object)this.metaDataStore);
        Mockito.when((Object)this.storageEngine.storeReadLayer()).thenReturn((Object)this.readLayer);
    }

    public KernelTransactionImplementation newTransaction(long transactionTimeoutMillis) {
        return this.newTransaction(0L, (AccessMode)AccessMode.Static.FULL, transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(AccessMode accessMode) {
        return this.newTransaction(0L, accessMode);
    }

    public KernelTransactionImplementation newTransaction(AccessMode accessMode, Locks.Client locks, boolean txTerminationAwareLocks) {
        return this.newTransaction(0L, accessMode, locks, txTerminationAwareLocks, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, AccessMode accessMode) {
        return this.newTransaction(lastTransactionIdWhenStarted, accessMode, this.defaultTransactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, AccessMode accessMode, long transactionTimeoutMillis) {
        return this.newTransaction(lastTransactionIdWhenStarted, accessMode, (Locks.Client)new NoOpClient(), false, transactionTimeoutMillis);
    }

    public KernelTransactionImplementation newTransaction(long lastTransactionIdWhenStarted, AccessMode accessMode, Locks.Client locks, boolean txTerminationAwareLocks, long transactionTimeout) {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction(txTerminationAwareLocks);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locks);
        tx.initialize(lastTransactionIdWhenStarted, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, accessMode, transactionTimeout);
        return tx;
    }

    public KernelTransactionImplementation newNotInitializedTransaction(boolean txTerminationAwareLocks) {
        return new KernelTransactionImplementation(null, this.schemaWriteGuard, this.hooks, null, null, this.headerInformationFactory, (TransactionCommitProcess)this.commitProcess, this.transactionMonitor, this.legacyIndexStateSupplier, this.txPool, (Clock)this.clock, TransactionTracer.NULL, this.storageEngine, txTerminationAwareLocks);
    }

    public class CapturingCommitProcess
    implements TransactionCommitProcess {
        private long txId = 1L;
        public TransactionRepresentation transaction;

        public long commit(TransactionToApply batch, CommitEvent commitEvent, TransactionApplicationMode mode) throws TransactionFailureException {
            assert (this.transaction == null) : "Designed to only allow one transaction";
            assert (batch.next() == null) : "Designed to only allow one transaction";
            this.transaction = batch.transactionRepresentation();
            return this.txId++;
        }
    }
}

