/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Clock;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.LegacyIndexTransactionState;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.SchemaWriteGuard;
import org.neo4j.kernel.impl.api.StatementOperationParts;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionHooks;
import org.neo4j.kernel.impl.api.state.ConstraintIndexCreator;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.kernel.impl.transaction.TransactionHeaderInformationFactory;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.tracing.TransactionTracer;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.time.FakeClock;

public class KernelTransactionTerminationTest {
    private static final int TEST_RUN_TIME_MS = 5000;

    @Test(timeout=10000L)
    public void transactionCantBeTerminatedAfterItIsClosed() throws Exception {
        this.runTwoThreads(tx -> tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed), tx -> {
            KernelTransactionTerminationTest.close((KernelTransaction)tx);
            Assert.assertNull((Object)tx.getReasonIfTerminated());
            tx.initialize();
        });
    }

    @Test(timeout=10000L)
    public void closeTransaction() throws Exception {
        LinkedBlockingQueue committerToTerminator = new LinkedBlockingQueue(1);
        LinkedBlockingQueue terminatorToCommitter = new LinkedBlockingQueue(1);
        this.runTwoThreads(tx -> {
            Boolean terminatorShouldAct = (Boolean)committerToTerminator.poll();
            if (terminatorShouldAct != null && terminatorShouldAct.booleanValue()) {
                TerminatorAction action = TerminatorAction.random();
                action.executeOn((KernelTransaction)tx);
                Assert.assertTrue((boolean)terminatorToCommitter.add(action));
            }
        }, tx -> {
            tx.initialize();
            CommitterAction committerAction = CommitterAction.random();
            committerAction.executeOn((KernelTransaction)tx);
            if (committerToTerminator.offer(true)) {
                TerminatorAction terminatorAction;
                try {
                    terminatorAction = (TerminatorAction)((Object)((Object)terminatorToCommitter.poll(1L, TimeUnit.SECONDS)));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
                if (terminatorAction != null) {
                    KernelTransactionTerminationTest.close(tx, committerAction, terminatorAction);
                }
            }
        });
    }

    private void runTwoThreads(Consumer<TestKernelTransaction> thread1Action, Consumer<TestKernelTransaction> thread2Action) throws Exception {
        TestKernelTransaction tx = TestKernelTransaction.create().initialize();
        CountDownLatch start = new CountDownLatch(1);
        AtomicBoolean stop = new AtomicBoolean();
        Future<?> action1 = Executors.newSingleThreadExecutor().submit(() -> {
            KernelTransactionTerminationTest.await(start);
            while (!stop.get()) {
                thread1Action.accept(tx);
            }
        });
        Future<?> action2 = Executors.newSingleThreadExecutor().submit(() -> {
            KernelTransactionTerminationTest.await(start);
            while (!stop.get()) {
                thread2Action.accept(tx);
            }
        });
        start.countDown();
        KernelTransactionTerminationTest.sleep();
        stop.set(true);
        Assert.assertNull(action1.get(1L, TimeUnit.MINUTES));
        Assert.assertNull(action2.get(1L, TimeUnit.MINUTES));
    }

    private static void await(CountDownLatch latch) {
        try {
            Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static void close(KernelTransaction tx) {
        try {
            tx.close();
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void close(TestKernelTransaction tx, CommitterAction committer, TerminatorAction terminator) {
        try {
            if (terminator == TerminatorAction.NONE) {
                committer.closeNotTerminated(tx);
            } else {
                committer.closeTerminated(tx);
            }
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private static void sleep() throws InterruptedException {
        Thread.sleep(5000L);
    }

    private static class CommitTrackingMonitor
    implements TransactionMonitor {
        volatile boolean committed;
        volatile boolean rolledBack;
        volatile boolean terminated;

        private CommitTrackingMonitor() {
        }

        public void transactionStarted() {
        }

        public void transactionFinished(boolean successful, boolean writeTx) {
            if (successful) {
                this.committed = true;
            } else {
                this.rolledBack = true;
            }
        }

        public void transactionTerminated(boolean writeTx) {
            this.terminated = true;
        }

        public void upgradeToWriteTransaction() {
        }

        void reset() {
            this.committed = false;
            this.rolledBack = false;
            this.terminated = false;
        }
    }

    private static class TestKernelTransaction
    extends KernelTransactionImplementation {
        final CommitTrackingMonitor monitor;

        TestKernelTransaction(CommitTrackingMonitor monitor) {
            super((StatementOperationParts)Mockito.mock(StatementOperationParts.class), (SchemaWriteGuard)Mockito.mock(SchemaWriteGuard.class), new TransactionHooks(), (ConstraintIndexCreator)Mockito.mock(ConstraintIndexCreator.class), new Procedures(), TransactionHeaderInformationFactory.DEFAULT, (TransactionCommitProcess)Mockito.mock(TransactionCommitProcess.class), (TransactionMonitor)monitor, () -> (LegacyIndexTransactionState)Mockito.mock(LegacyIndexTransactionState.class), (Pool)Mockito.mock(Pool.class), (Clock)new FakeClock(), TransactionTracer.NULL, (StorageEngine)Mockito.mock(StorageEngine.class, (Answer)Mockito.RETURNS_MOCKS), true);
            this.monitor = monitor;
        }

        static TestKernelTransaction create() {
            return new TestKernelTransaction(new CommitTrackingMonitor());
        }

        TestKernelTransaction initialize() {
            this.initialize(42L, 42L, (StatementLocks)new SimpleStatementLocks((Locks.Client)new NoOpClient()), KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL, 0L);
            this.monitor.reset();
            return this;
        }

        void assertCommitted() {
            Assert.assertTrue((boolean)this.monitor.committed);
        }

        void assertRolledBack() {
            Assert.assertTrue((boolean)this.monitor.rolledBack);
        }

        void assertTerminated() {
            Assert.assertEquals((Object)Status.Transaction.TransactionMarkedAsFailed, (Object)this.getReasonIfTerminated());
            Assert.assertTrue((boolean)this.monitor.terminated);
        }

        void assertNotTerminated() {
            Assert.assertNull((Object)this.getReasonIfTerminated());
            Assert.assertFalse((boolean)this.monitor.terminated);
        }
    }

    private static enum CommitterAction {
        NONE{

            @Override
            void executeOn(KernelTransaction tx) {
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertTerminated();
                tx.close();
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.close();
                tx.assertRolledBack();
            }
        }
        ,
        MARK_SUCCESS{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.success();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) {
                tx.assertTerminated();
                try {
                    tx.close();
                    Assert.fail((String)"Exception expected");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
                }
                tx.assertRolledBack();
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                tx.assertNotTerminated();
                tx.close();
                tx.assertCommitted();
            }
        }
        ,
        MARK_FAILURE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.failure();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeTerminated(tx);
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                NONE.closeNotTerminated(tx);
            }
        }
        ,
        MARK_SUCCESS_AND_FAILURE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.success();
                tx.failure();
            }

            @Override
            void closeTerminated(TestKernelTransaction tx) throws TransactionFailureException {
                MARK_SUCCESS.closeTerminated(tx);
            }

            @Override
            void closeNotTerminated(TestKernelTransaction tx) {
                tx.assertNotTerminated();
                try {
                    tx.close();
                    Assert.fail((String)"Exception expected");
                }
                catch (Exception e) {
                    Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
                }
                tx.assertRolledBack();
            }
        };

        static final CommitterAction[] VALUES;

        abstract void executeOn(KernelTransaction var1);

        abstract void closeTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        abstract void closeNotTerminated(TestKernelTransaction var1) throws TransactionFailureException;

        static CommitterAction random() {
            return VALUES[ThreadLocalRandom.current().nextInt(VALUES.length)];
        }

        static {
            VALUES = CommitterAction.values();
        }
    }

    private static enum TerminatorAction {
        NONE{

            @Override
            void executeOn(KernelTransaction tx) {
            }
        }
        ,
        TERMINATE{

            @Override
            void executeOn(KernelTransaction tx) {
                tx.markForTermination((Status)Status.Transaction.TransactionMarkedAsFailed);
            }
        };


        abstract void executeOn(KernelTransaction var1);

        static TerminatorAction random() {
            return ThreadLocalRandom.current().nextBoolean() ? TERMINATE : NONE;
        }
    }
}

