/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.collection.pool.Pool;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.NoOpClient;
import org.neo4j.kernel.impl.locking.SimpleStatementLocks;
import org.neo4j.kernel.impl.locking.StatementLocks;
import org.neo4j.kernel.impl.transaction.TransactionMonitor;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageStatement;
import org.neo4j.storageengine.api.lock.ResourceLocker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.test.DoubleLatch;

@RunWith(value=Parameterized.class)
public class KernelTransactionImplementationTest
extends KernelTransactionTestBase {
    @Parameterized.Parameter(value=0)
    public Consumer<KernelTransaction> transactionInitializer;
    @Parameterized.Parameter(value=1)
    public boolean isWriteTx;
    @Parameterized.Parameter(value=2)
    public String ignored;

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> parameters() {
        Consumer<KernelTransaction> readTxInitializer = tx -> {};
        Consumer<KernelTransaction> writeTxInitializer = tx -> {
            KernelStatement statement = (KernelStatement)tx.acquireStatement();
            statement.txState().nodeDoCreate(42L);
        };
        return Arrays.asList({readTxInitializer, false, "read"}, {writeTxInitializer, true, "write"});
    }

    @Test
    public void shouldCommitSuccessfulTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.success();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    private AccessMode accessMode() {
        return this.isWriteTx ? AccessMode.Static.WRITE : AccessMode.Static.READ;
    }

    @Test
    public void shouldRollbackUnsuccessfulTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackFailedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.failure();
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackAndThrowOnFailedAndSuccess() throws Exception {
        boolean exceptionReceived = false;
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.failure();
            transaction.success();
        }
        catch (TransactionFailureException e) {
            exceptionReceived = true;
        }
        Assert.assertTrue((boolean)exceptionReceived);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingTerminatedTransaction() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.markForTermination((Status)Status.General.UnknownError);
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingSuccessfulButTerminatedTransaction() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            Assert.assertEquals((Object)Status.General.UnknownError, (Object)transaction.getReasonIfTerminated());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldRollbackOnClosingTerminatedButSuccessfulTransaction() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.success();
        Assert.assertEquals((Object)Status.General.UnknownError, (Object)transaction.getReasonIfTerminated());
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldNotDowngradeFailureState() throws Exception {
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            this.transactionInitializer.accept((KernelTransaction)transaction);
            transaction.markForTermination((Status)Status.General.UnknownError);
            transaction.failure();
            Assert.assertEquals((Object)Status.General.UnknownError, (Object)transaction.getReasonIfTerminated());
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldIgnoreTerminateAfterCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.close();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(true, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldIgnoreTerminateAfterRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.close();
        transaction.markForTermination((Status)Status.General.UnknownError);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test(expected=TransactionTerminatedException.class)
    public void shouldThrowOnTerminationInCommit() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.success();
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.close();
    }

    @Test
    public void shouldIgnoreTerminationDuringRollback() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        transaction.markForTermination((Status)Status.General.UnknownError);
        transaction.close();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldAllowTerminatingFromADifferentThread() throws Exception {
        ChildException childException = new ChildException();
        DoubleLatch latch = new DoubleLatch(1);
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        this.transactionInitializer.accept((KernelTransaction)transaction);
        Future<?> terminationFuture = Executors.newSingleThreadExecutor().submit(() -> KernelTransactionImplementationTest.lambda$shouldAllowTerminatingFromADifferentThread$2(latch, (KernelTransaction)transaction));
        transaction.success();
        latch.startAndAwaitFinish();
        Assert.assertNull(terminationFuture.get(1L, TimeUnit.MINUTES));
        try {
            transaction.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionFinished(false, this.isWriteTx);
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).transactionTerminated(this.isWriteTx);
        this.verifyExtraInteractionWithTheMonitor(this.transactionMonitor, this.isWriteTx);
    }

    @Test
    public void shouldUseStartTimeAndTxIdFromWhenStartingTxAsHeader() throws Exception {
        long startingTime = this.clock.millis();
        Mockito.when((Object)this.legacyIndexState.hasChanges()).thenReturn((Object)true);
        ((StorageEngine)Mockito.doAnswer(invocation -> {
            Collection commands = (Collection)invocation.getArgumentAt(0, Collection.class);
            commands.add(Mockito.mock(Command.class));
            return null;
        }).when((Object)this.storageEngine)).createCommands((Collection)org.mockito.Matchers.any(Collection.class), (ReadableTransactionState)org.mockito.Matchers.any(TransactionState.class), (StorageStatement)org.mockito.Matchers.any(StorageStatement.class), (ResourceLocker)org.mockito.Matchers.any(ResourceLocker.class), org.mockito.Matchers.anyLong());
        try (KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());){
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)Mockito.mock(Locks.Client.class));
            transaction.initialize(5L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, (AccessMode)AccessMode.Static.FULL, 0L);
            try (KernelStatement statement = transaction.acquireStatement();){
                statement.legacyIndexTxState();
            }
            this.clock.forward(5L, TimeUnit.MILLISECONDS);
            Mockito.when((Object)this.metaDataStore.getLastCommittedTransactionId()).thenReturn((Object)7L);
            transaction.success();
        }
        Assert.assertEquals((long)5L, (long)this.commitProcess.transaction.getLatestCommittedTxWhenStarted());
        Assert.assertEquals((long)startingTime, (long)this.commitProcess.transaction.getTimeStarted());
        Assert.assertEquals((long)(startingTime + 5L), (long)this.commitProcess.transaction.getTimeCommitted());
    }

    @Test
    public void successfulTxShouldNotifyKernelTransactionsThatItIsClosed() throws TransactionFailureException {
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode());
        tx.success();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    @Test
    public void failedTxShouldNotifyKernelTransactionsThatItIsClosed() throws TransactionFailureException {
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode());
        tx.failure();
        tx.close();
        ((Pool)Mockito.verify((Object)this.txPool)).release((Object)tx);
    }

    private void verifyExtraInteractionWithTheMonitor(TransactionMonitor transactionMonitor, boolean isWriteTx) {
        if (isWriteTx) {
            ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor, (VerificationMode)Mockito.times((int)1))).upgradeToWriteTransaction();
        }
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{transactionMonitor});
    }

    @Test
    public void shouldIncrementReuseCounterOnReuse() throws Exception {
        KernelTransactionImplementation transaction = this.newTransaction(this.accessMode());
        int reuseCount = transaction.getReuseCount();
        transaction.close();
        SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
        transaction.initialize(1L, 0L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.accessMode(), 0L);
        Assert.assertEquals((long)(reuseCount + 1), (long)transaction.getReuseCount());
    }

    @Test
    public void markForTerminationNotInitializedTransaction() {
        KernelTransactionImplementation tx = this.newNotInitializedTransaction(true);
        tx.markForTermination((Status)Status.General.UnknownError);
        Assert.assertEquals((Object)Status.General.UnknownError, (Object)tx.getReasonIfTerminated());
    }

    @Test
    public void markForTerminationInitializedTransaction() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        tx.markForTermination((Status)Status.General.UnknownError);
        Assert.assertEquals((Object)Status.General.UnknownError, (Object)tx.getReasonIfTerminated());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @Test
    public void markForTerminationTerminatedTransaction() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.markForTermination((Status)Status.Transaction.Outdated);
        tx.markForTermination((Status)Status.Transaction.LockClientStopped);
        Assert.assertEquals((Object)Status.Transaction.Terminated, (Object)tx.getReasonIfTerminated());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedNeitherSuccessNorFailureClosesWithoutThrowing() throws TransactionFailureException {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedForSuccessThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.markForTermination((Status)Status.General.UnknownError);
        try {
            tx.close();
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void terminatedTxMarkedForFailureClosesWithoutThrowing() throws TransactionFailureException {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        tx.close();
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
        ((TransactionMonitor)Mockito.verify((Object)this.transactionMonitor)).transactionTerminated(this.isWriteTx);
    }

    @Test
    public void terminatedTxMarkedForBothSuccessAndFailureThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        this.transactionInitializer.accept((KernelTransaction)tx);
        tx.success();
        tx.failure();
        tx.markForTermination((Status)Status.General.UnknownError);
        try {
            tx.close();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionTerminatedException.class));
        }
    }

    @Test
    public void txMarkedForBothSuccessAndFailureThrowsOnClose() {
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode(), locksClient, true);
        tx.success();
        tx.failure();
        try {
            tx.close();
        }
        catch (Exception e) {
            Assert.assertThat((Object)e, (Matcher)Matchers.instanceOf(TransactionFailureException.class));
        }
    }

    @Test
    public void initializedTransactionShouldHaveNoTerminationReason() throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode());
        Assert.assertNull((Object)tx.getReasonIfTerminated());
    }

    @Test
    public void shouldReportCorrectTerminationReason() throws Exception {
        Status.Transaction status = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode());
        tx.markForTermination((Status)status);
        Assert.assertSame((Object)status, (Object)tx.getReasonIfTerminated());
    }

    @Test
    public void closedTransactionShouldHaveNoTerminationReason() throws Exception {
        KernelTransactionImplementation tx = this.newTransaction(this.accessMode());
        tx.markForTermination((Status)Status.Transaction.Terminated);
        tx.close();
        Assert.assertNull((Object)tx.getReasonIfTerminated());
    }

    @Test
    public void transactionWithCustomTimeout() {
        long transactionTimeout = 5L;
        KernelTransactionImplementation transaction = this.newTransaction(transactionTimeout);
        Assert.assertEquals((String)"Transaction should have custom configured timeout.", (long)transactionTimeout, (long)transaction.timeout());
    }

    @Test
    public void transactionStartTime() {
        long startTime = this.clock.forward(5L, TimeUnit.MINUTES).millis();
        KernelTransactionImplementation transaction = this.newTransaction((AccessMode)AccessMode.Static.FULL);
        Assert.assertEquals((String)"Transaction start time should be the same as clock time.", (long)startTime, (long)transaction.startTime());
    }

    @Test
    public void markForTerminationWithCorrectReuseCount() throws Exception {
        int reuseCount = 10;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction(true);
        this.initializeAndClose(tx, reuseCount);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.accessMode(), 0L);
        tx.markForTermination((long)reuseCount, (Status)terminationReason);
        Assert.assertEquals((Object)terminationReason, (Object)tx.getReasonIfTerminated());
        ((Locks.Client)Mockito.verify((Object)locksClient)).stop();
    }

    @Test
    public void markForTerminationWithIncorrectReuseCount() throws Exception {
        int reuseCount = 13;
        int nextReuseCount = reuseCount + 2;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = this.newNotInitializedTransaction(true);
        this.initializeAndClose(tx, reuseCount);
        Locks.Client locksClient = (Locks.Client)Mockito.mock(Locks.Client.class);
        SimpleStatementLocks statementLocks = new SimpleStatementLocks(locksClient);
        tx.initialize(42L, 42L, (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.accessMode(), 0L);
        tx.markForTermination((long)nextReuseCount, (Status)terminationReason);
        Assert.assertNull((Object)tx.getReasonIfTerminated());
        ((Locks.Client)Mockito.verify((Object)locksClient, (VerificationMode)Mockito.never())).stop();
    }

    private void initializeAndClose(KernelTransactionImplementation tx, int times) throws Exception {
        for (int i = 0; i < times; ++i) {
            SimpleStatementLocks statementLocks = new SimpleStatementLocks((Locks.Client)new NoOpClient());
            tx.initialize((long)(i + 10), (long)(i + 10), (StatementLocks)statementLocks, KernelTransaction.Type.implicit, this.accessMode(), 0L);
            tx.close();
        }
    }

    private static /* synthetic */ void lambda$shouldAllowTerminatingFromADifferentThread$2(DoubleLatch latch, KernelTransaction transaction) {
        latch.awaitStart();
        transaction.markForTermination((Status)Status.General.UnknownError);
        latch.finish();
    }

    class ChildException {
        public Exception exception = null;

        ChildException() {
        }
    }
}

