/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionImplementationHandle;

public class KernelTransactionImplementationHandleTest {
    @Test
    public void returnsCorrectLastTransactionTimestampWhenStarted() {
        long lastCommittedTxTimestamp = 42L;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.lastTransactionTimestampWhenStarted()).thenReturn((Object)lastCommittedTxTimestamp);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx);
        Assert.assertEquals((long)lastCommittedTxTimestamp, (long)handle.lastTransactionTimestampWhenStarted());
    }

    @Test
    public void returnsCorrectLastTransactionTimestampWhenStartedForClosedTx() {
        long lastCommittedTxTimestamp = 4242L;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.lastTransactionTimestampWhenStarted()).thenReturn((Object)lastCommittedTxTimestamp);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)false);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx);
        Assert.assertEquals((long)lastCommittedTxTimestamp, (long)handle.lastTransactionTimestampWhenStarted());
    }

    @Test
    public void isOpenForUnchangedKernelTransactionImplementation() {
        int reuseCount = 42;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)reuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx);
        Assert.assertTrue((boolean)handle.isOpen());
    }

    @Test
    public void isOpenForReusedKernelTransactionImplementation() {
        int initialReuseCount = 42;
        int nextReuseCount = 4242;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)initialReuseCount).thenReturn((Object)nextReuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx);
        Assert.assertFalse((boolean)handle.isOpen());
    }

    @Test
    public void markForTerminationCallsKernelTransactionImplementation() {
        int reuseCount = 42;
        Status.Transaction terminationReason = Status.Transaction.Terminated;
        KernelTransactionImplementation tx = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)tx.getReuseCount()).thenReturn((Object)reuseCount);
        KernelTransactionImplementationHandle handle = new KernelTransactionImplementationHandle(tx);
        handle.markForTermination((Status)terminationReason);
        ((KernelTransactionImplementation)Mockito.verify((Object)tx)).markForTermination((long)reuseCount, (Status)terminationReason);
    }
}

