/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.SchemaWriteOperations;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.api.KernelTransactionTestBase;

public class KernelTransactionAccessModeTest
extends KernelTransactionTestBase {
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldNotAllowReadsInNoneMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.NONE);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().readOperations();
    }

    @Test
    public void shouldNotAllowWritesInNoneMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.NONE);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().dataWriteOperations();
    }

    @Test
    public void shouldNotAllowSchemaWritesInNoneMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.NONE);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldAllowReadsInReadMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.READ);
        ReadOperations reads = tx.acquireStatement().readOperations();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldNotAllowWriteAccessInReadMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.READ);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().dataWriteOperations();
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInReadMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.READ);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldNotAllowReadAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE_ONLY);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().readOperations();
    }

    @Test
    public void shouldAllowWriteAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE_ONLY);
        DataWriteOperations writes = tx.acquireStatement().dataWriteOperations();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInWriteOnlyMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE_ONLY);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldAllowReadsInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE);
        ReadOperations reads = tx.acquireStatement().readOperations();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldAllowWritesInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE);
        DataWriteOperations writes = tx.acquireStatement().dataWriteOperations();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldNotAllowSchemaWriteAccessInWriteMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.WRITE);
        this.exception.expect(AuthorizationViolationException.class);
        tx.acquireStatement().schemaWriteOperations();
    }

    @Test
    public void shouldAllowReadsInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.FULL);
        ReadOperations reads = tx.acquireStatement().readOperations();
        Assert.assertNotNull((Object)reads);
    }

    @Test
    public void shouldAllowWritesInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.FULL);
        DataWriteOperations writes = tx.acquireStatement().dataWriteOperations();
        Assert.assertNotNull((Object)writes);
    }

    @Test
    public void shouldAllowSchemaWriteAccessInFullMode() throws Throwable {
        KernelTransactionImplementation tx = this.newTransaction((AccessMode)AccessMode.Static.FULL);
        SchemaWriteOperations writes = tx.acquireStatement().schemaWriteOperations();
        Assert.assertNotNull((Object)writes);
    }
}

