/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.StorageStatement;

public class KernelStatementTest {
    @Test(expected=TransactionTerminatedException.class)
    public void shouldThrowTerminateExceptionWhenTransactionTerminated() throws Exception {
        KernelTransactionImplementation transaction = (KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class);
        Mockito.when((Object)transaction.getReasonIfTerminated()).thenReturn((Object)Status.Transaction.Terminated);
        Mockito.when((Object)transaction.mode()).thenReturn((Object)AccessMode.Static.FULL);
        KernelStatement statement = new KernelStatement(transaction, null, null, (StorageStatement)Mockito.mock(StorageStatement.class), null);
        statement.acquire();
        statement.readOperations().nodeExists(0L);
    }

    @Test
    public void shouldReleaseStorageStatementWhenForceClosed() throws Exception {
        StorageStatement storeStatement = (StorageStatement)Mockito.mock(StorageStatement.class);
        KernelStatement statement = new KernelStatement((KernelTransactionImplementation)Mockito.mock(KernelTransactionImplementation.class), null, null, storeStatement, new Procedures());
        statement.acquire();
        statement.forceClose();
        ((StorageStatement)Mockito.verify((Object)storeStatement)).release();
    }
}

