/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.kernel.api.DataWriteOperations;
import org.neo4j.kernel.api.legacyindex.AutoIndexOperations;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.legacyindex.InternalAutoIndexOperations;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.coreapi.IndexProvider;
import org.neo4j.storageengine.api.Token;

public class AutoIndexOperationsTest {
    private final IndexProvider indexProvider = (IndexProvider)Mockito.mock(IndexProvider.class, (Answer)Mockito.RETURNS_MOCKS);
    private final DataWriteOperations ops = (DataWriteOperations)Mockito.mock(DataWriteOperations.class);
    private final PropertyKeyTokenHolder tokens = (PropertyKeyTokenHolder)Mockito.mock(PropertyKeyTokenHolder.class);
    private final AutoIndexOperations index = new InternalAutoIndexOperations(this.tokens, InternalAutoIndexOperations.EntityType.NODE);
    private final int nonIndexedProperty = 1337;
    private final String nonIndexedPropertyName = "foo";
    private final int indexedProperty = 1338;
    private final String indexedPropertyName = "bar";

    @Before
    public void setup() throws TokenNotFoundException {
        Mockito.when((Object)this.tokens.getTokenById(1337)).thenReturn((Object)new Token("foo", 1337));
        Mockito.when((Object)this.tokens.getTokenById(1338)).thenReturn((Object)new Token("bar", 1337));
    }

    @Test
    public void shouldNotRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyRemoved(this.ops, 11L, 1337);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }

    @Test
    public void shouldNotAddToIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyAdded(this.ops, 11L, (Property)Property.property((int)1337, (Object)"Hello!"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }

    @Test
    public void shouldNotAddOrRemoveFromIndexForNonAutoIndexedProperty() throws Exception {
        this.index.startAutoIndexingProperty("bar");
        this.index.propertyChanged(this.ops, 11L, (Property)Property.property((int)1337, (Object)"Goodbye!"), (Property)Property.property((int)1337, (Object)"Hello!"));
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.ops});
    }
}

