/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.extension;

import java.util.Map;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.extension.KernelExtensions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.TestGraphDatabaseFactory;

public abstract class KernelExtensionFactoryContractTest {
    protected final Class<? extends KernelExtensionFactory<?>> extClass;
    private final String key;
    @Rule
    public TargetDirectory.TestDirectory target = TargetDirectory.testDirForTest(this.getClass());

    public KernelExtensionFactoryContractTest(String key, Class<? extends KernelExtensionFactory<?>> extClass) {
        this.extClass = extClass;
        this.key = key;
    }

    public GraphDatabaseAPI graphdb(int instance) {
        Map<String, String> config = this.configuration(true, instance);
        return (GraphDatabaseAPI)new TestGraphDatabaseFactory().newImpermanentDatabaseBuilder().setConfig(config).newGraphDatabase();
    }

    protected Map<String, String> configuration(boolean shouldLoad, int instance) {
        return MapUtil.stringMap((String[])new String[0]);
    }

    static KernelExtensions getExtensions(GraphDatabaseService graphdb) {
        return (KernelExtensions)((GraphDatabaseAPI)graphdb).getDependencyResolver().resolveDependency(KernelExtensions.class);
    }

    @Test
    public void extensionShouldHavePublicNoArgConstructor() throws Exception {
        KernelExtensionFactory<?> instance = null;
        try {
            instance = this.newInstance();
        }
        catch (IllegalArgumentException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Contract violation: extension class must have public no-arg constructor (Exception in stderr)");
        }
        Assert.assertNotNull(instance);
    }

    @Test
    public void shouldBeAbleToLoadExtensionAsAServiceProvider() throws Exception {
        KernelExtensionFactory<?> instance = null;
        try {
            instance = this.loadInstance();
        }
        catch (ClassCastException failure) {
            failure.printStackTrace();
            Assert.fail((String)"Loaded instance does not match the extension class (Exception in stderr)");
        }
        Assert.assertNotNull((String)"Could not load the kernel extension with the provided key", instance);
        Assert.assertTrue((String)"Class of the loaded instance is a subclass of the extension class", (instance.getClass() == this.extClass ? 1 : 0) != 0);
    }

    @Test
    public void differentInstancesShouldHaveEqualHashCodesAndBeEqual() throws Exception {
        KernelExtensionFactory<?> one = this.newInstance();
        KernelExtensionFactory<?> two = this.newInstance();
        Assert.assertEquals((String)"new instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"new instances are not equals", one, two);
        one = this.loadInstance();
        two = this.loadInstance();
        Assert.assertEquals((String)"loaded instances have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instances are not equals", one, two);
        one = this.loadInstance();
        two = this.newInstance();
        Assert.assertEquals((String)"loaded instance and new instance have different hash codes", (long)one.hashCode(), (long)two.hashCode());
        Assert.assertEquals((String)"loaded instance and new instance are not equals", one, two);
    }

    @Test
    public void canLoadKernelExtension() throws Exception {
        GraphDatabaseAPI graphdb = this.graphdb(0);
        try {
            Assert.assertTrue((String)"Failed to load extension", (boolean)KernelExtensionFactoryContractTest.getExtensions((GraphDatabaseService)graphdb).isRegistered(this.extClass));
        }
        finally {
            graphdb.shutdown();
        }
    }

    private final KernelExtensionFactory<?> newInstance() {
        try {
            return this.extClass.newInstance();
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("Could not instantiate extension class", cause);
        }
    }

    protected final KernelExtensionFactory<?> loadInstance() {
        return this.extClass.cast(Service.load(KernelExtensionFactory.class, (String)this.key));
    }
}

