/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.configuration;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.configuration.ConfigurationMigrator;
import org.neo4j.kernel.configuration.GraphDatabaseConfigurationMigrator;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

public class TestGraphDatabaseConfigurationMigrator {
    private ConfigurationMigrator migrator;
    @Rule
    public AssertableLogProvider logProvider = new AssertableLogProvider(true);

    @Before
    public void setUp() {
        this.migrator = new GraphDatabaseConfigurationMigrator();
    }

    @Test
    public void testNoMigration() {
        Assert.assertThat((Object)this.migrator.apply(MapUtil.stringMap((String[])new String[]{"foo", "bar"}), (Log)NullLog.getInstance()), (Matcher)CoreMatchers.equalTo((Object)MapUtil.stringMap((String[])new String[]{"foo", "bar"})));
    }

    @Test
    public void migrateIndexSamplingBufferSizeIfPresent() {
        Map resultConfig = this.migrator.apply(MapUtil.stringMap((String[])new String[]{"dbms.index_sampling.buffer_size", "64m"}), (Log)NullLog.getInstance());
        Assert.assertEquals((String)"Old property should be migrated to new one with correct value", (Object)resultConfig, (Object)MapUtil.stringMap((String[])new String[]{"dbms.index_sampling.sample_size_limit", "8388608"}));
    }

    @Test
    public void skipMigrationOfIndexSamplingBufferSizeIfNotPresent() {
        Map resultConfig = this.migrator.apply(MapUtil.stringMap((String[])new String[]{"dbms.index_sampling.sample_size_limit", "8388600"}), (Log)NullLog.getInstance());
        Assert.assertEquals((String)"Nothing to migrate should be the same", (Object)resultConfig, (Object)MapUtil.stringMap((String[])new String[]{"dbms.index_sampling.sample_size_limit", "8388600"}));
    }

    @Test
    public void migrateExecutionTimeLimitIfPresent() {
        Map migratedProperties = this.migrator.apply(MapUtil.stringMap((String[])new String[]{"unsupported.dbms.executiontime_limit.time", "120s"}), this.getLog());
        Assert.assertEquals((String)"Old property should be migrated to new", (Object)migratedProperties, (Object)MapUtil.stringMap((String[])new String[]{"dbms.transaction.timeout", "120s"}));
        this.assertContainsWarningMessage("unsupported.dbms.executiontime_limit.time has been replaced with dbms.transaction.timeout.");
    }

    @Test
    public void skipMigrationOfExecutionTimeLimitIfNotPresent() {
        Map migratedProperties = this.migrator.apply(MapUtil.stringMap((String[])new String[]{"dbms.transaction.timeout", "120s"}), this.getLog());
        Assert.assertEquals((String)"Nothing to migrate", (Object)migratedProperties, (Object)MapUtil.stringMap((String[])new String[]{"dbms.transaction.timeout", "120s"}));
        this.logProvider.assertNoLoggingOccurred();
    }

    @Test
    public void skipMigrationOfExecutionTimeLimitIfTransactionTimeoutConfigured() {
        Map migratedProperties = this.migrator.apply(MapUtil.stringMap((String[])new String[]{"unsupported.dbms.executiontime_limit.time", "12s", "dbms.transaction.timeout", "120s"}), this.getLog());
        Assert.assertEquals((String)"Should keep pre configured transaction timeout.", (Object)migratedProperties, (Object)MapUtil.stringMap((String[])new String[]{"dbms.transaction.timeout", "120s"}));
        this.assertContainsWarningMessage();
    }

    private void assertContainsWarningMessage() {
        this.logProvider.assertContainsMessageContaining("WARNING! Deprecated configuration options used. See manual for details");
    }

    private void assertContainsWarningMessage(String deprecationMessage) {
        this.assertContainsWarningMessage();
        if (StringUtils.isNotEmpty((CharSequence)deprecationMessage)) {
            this.logProvider.assertContainsMessageContaining(deprecationMessage);
        }
    }

    private Log getLog() {
        return this.logProvider.getLog(GraphDatabaseConfigurationMigrator.class);
    }
}

