/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.builtinprocs;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.collection.RawIterator;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.ReadOperations;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.NodePropertyExistenceConstraint;
import org.neo4j.kernel.api.constraints.PropertyConstraint;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.dbms.DbmsOperations;
import org.neo4j.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.ProcedureSignature;
import org.neo4j.kernel.builtinprocs.BuiltInProcedures;
import org.neo4j.kernel.builtinprocs.ListIndexesProcedure;
import org.neo4j.kernel.impl.factory.Edition;
import org.neo4j.kernel.impl.proc.Procedures;
import org.neo4j.storageengine.api.Token;

public class BuiltInProceduresTest {
    private final List<IndexDescriptor> indexes = new LinkedList<IndexDescriptor>();
    private final List<IndexDescriptor> uniqueIndexes = new LinkedList<IndexDescriptor>();
    private final List<PropertyConstraint> constraints = new LinkedList<PropertyConstraint>();
    private final Map<Integer, String> labels = new HashMap<Integer, String>();
    private final Map<Integer, String> propKeys = new HashMap<Integer, String>();
    private final Map<Integer, String> relTypes = new HashMap<Integer, String>();
    private final ReadOperations read = (ReadOperations)Mockito.mock(ReadOperations.class);
    private final DbmsOperations dbms = (DbmsOperations)Mockito.mock(DbmsOperations.class);
    private final Statement statement = (Statement)Mockito.mock(Statement.class);
    private final KernelTransaction tx = (KernelTransaction)Mockito.mock(KernelTransaction.class);
    private final Procedures procs = new Procedures();

    @Test
    public void shouldListAllIndexes() throws Throwable {
        this.givenIndex("User", "name");
        List<Object[]> call = this.call("db.indexes", new Object[0]);
        MatcherAssert.assertThat(call, (Matcher)Matchers.contains(this.record("INDEX ON :User(name)", "online", ListIndexesProcedure.IndexType.NODE_LABEL_PROPERTY.typeName())));
    }

    @Test
    public void shouldListAllUniqueIndexes() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        MatcherAssert.assertThat(this.call("db.indexes", new Object[0]), (Matcher)Matchers.contains(this.record("INDEX ON :User(name)", "online", ListIndexesProcedure.IndexType.NODE_UNIQUE_PROPERTY.typeName())));
    }

    @Test
    public void shouldListPropertyKeys() throws Throwable {
        this.givenPropertyKeys("name", "age");
        MatcherAssert.assertThat(this.call("db.propertyKeys", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("age"), this.record("name")}));
    }

    @Test
    public void shouldListLabels() throws Throwable {
        this.givenLabels("Banana", "Fruit");
        MatcherAssert.assertThat(this.call("db.labels", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("Banana"), this.record("Fruit")}));
    }

    @Test
    public void shouldListRelTypes() throws Throwable {
        this.givenRelationshipTypes("EATS", "SPROUTS");
        MatcherAssert.assertThat(this.call("db.relationshipTypes", new Object[0]), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.record("EATS"), this.record("SPROUTS")}));
    }

    @Test
    public void shouldListConstraints() throws Throwable {
        this.givenUniqueConstraint("User", "name");
        this.givenNodePropExistenceConstraint("User", "name");
        MatcherAssert.assertThat(this.call("db.constraints", new Object[0]), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.record("CONSTRAINT ON ( user:User ) ASSERT exists(user.name)"), this.record("CONSTRAINT ON ( user:User ) ASSERT user.name IS UNIQUE")}));
    }

    @Test
    public void shouldEscapeLabelNameContainingColons() throws Throwable {
        this.givenUniqueConstraint("FOO:BAR", "x.y");
        this.givenNodePropExistenceConstraint("FOO:BAR", "x.y");
        List<Object[]> call = this.call("db.constraints", new Object[0]);
        MatcherAssert.assertThat(call, (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT `foo:bar`.x.y IS UNIQUE"), this.record("CONSTRAINT ON ( `foo:bar`:`FOO:BAR` ) ASSERT exists(`foo:bar`.x.y)")}));
    }

    @Test
    public void shouldListCorrectBuiltinProcedures() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.procedures", new Object[0]), (Matcher)Matchers.contains((Matcher[])new Matcher[]{this.record("db.constraints", "db.constraints() :: (description :: STRING?)"), this.record("db.indexes", "db.indexes() :: (description :: STRING?, state :: STRING?, type :: STRING?)"), this.record("db.labels", "db.labels() :: (label :: STRING?)"), this.record("db.propertyKeys", "db.propertyKeys() :: (propertyKey :: STRING?)"), this.record("db.relationshipTypes", "db.relationshipTypes() :: (relationshipType :: STRING?)"), this.record("dbms.changePassword", "dbms.changePassword(password :: STRING?) :: ()"), this.record("dbms.components", "dbms.components() :: (name :: STRING?, versions :: LIST? OF STRING?, edition :: STRING?)"), this.record("dbms.procedures", "dbms.procedures() :: (name :: STRING?, signature :: STRING?)"), this.record("dbms.queryJmx", "dbms.queryJmx(query :: STRING?) :: (name :: STRING?, description :: STRING?, attributes :: MAP?)")}));
    }

    @Test
    public void shouldListSystemComponents() throws Throwable {
        MatcherAssert.assertThat(this.call("dbms.components", new Object[0]), (Matcher)Matchers.contains(this.record("Neo4j Kernel", Collections.singletonList("1.3.37"), "enterprise")));
    }

    private Matcher<Object[]> record(Object ... fields) {
        return Matchers.equalTo((Object)fields);
    }

    private void givenIndex(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        this.indexes.add(new IndexDescriptor(labelId, propId));
    }

    private void givenUniqueIndex(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        this.uniqueIndexes.add(new IndexDescriptor(labelId, propId));
    }

    private void givenUniqueConstraint(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        this.uniqueIndexes.add(new IndexDescriptor(labelId, propId));
        this.constraints.add((PropertyConstraint)new UniquenessConstraint(labelId, propId));
    }

    private void givenNodePropExistenceConstraint(String label, String propKey) {
        int labelId = this.token(label, this.labels);
        int propId = this.token(propKey, this.propKeys);
        this.constraints.add((PropertyConstraint)new NodePropertyExistenceConstraint(labelId, propId));
    }

    private void givenPropertyKeys(String ... keys) {
        for (String key : keys) {
            this.token(key, this.propKeys);
        }
    }

    private void givenLabels(String ... labelNames) {
        for (String key : labelNames) {
            this.token(key, this.labels);
        }
    }

    private void givenRelationshipTypes(String ... types) {
        for (String key : types) {
            this.token(key, this.relTypes);
        }
    }

    private Integer token(String name, Map<Integer, String> tokens) {
        return tokens.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(name)).map(Map.Entry::getKey).findFirst().orElseGet(() -> {
            int newIndex = tokens.size();
            tokens.put(newIndex, name);
            return newIndex;
        });
    }

    @Before
    public void setup() throws Exception {
        new BuiltInProcedures("1.3.37", Edition.enterprise.toString()).accept(this.procs);
        Mockito.when((Object)this.tx.acquireStatement()).thenReturn((Object)this.statement);
        Mockito.when((Object)this.statement.readOperations()).thenReturn((Object)this.read);
        Mockito.when((Object)this.read.propertyKeyGetAllTokens()).thenAnswer(this.asTokens(this.propKeys));
        Mockito.when((Object)this.read.labelsGetAllTokens()).thenAnswer(this.asTokens(this.labels));
        Mockito.when((Object)this.read.relationshipTypesGetAllTokens()).thenAnswer(this.asTokens(this.relTypes));
        Mockito.when((Object)this.read.indexesGetAll()).thenAnswer(i -> this.indexes.iterator());
        Mockito.when((Object)this.read.uniqueIndexesGetAll()).thenAnswer(i -> this.uniqueIndexes.iterator());
        Mockito.when((Object)this.read.constraintsGetAll()).thenAnswer(i -> this.constraints.iterator());
        Mockito.when((Object)this.read.proceduresGetAll()).thenReturn((Object)this.procs.getAll());
        Mockito.when((Object)this.read.propertyKeyGetName(org.mockito.Matchers.anyInt())).thenAnswer(invocation -> this.propKeys.get((int)((Integer)invocation.getArguments()[0])));
        Mockito.when((Object)this.read.labelGetName(org.mockito.Matchers.anyInt())).thenAnswer(invocation -> this.labels.get((int)((Integer)invocation.getArguments()[0])));
        Mockito.when((Object)this.read.relationshipTypeGetName(org.mockito.Matchers.anyInt())).thenAnswer(invocation -> this.relTypes.get((int)((Integer)invocation.getArguments()[0])));
        Mockito.when((Object)this.read.constraintsGetForRelationshipType(org.mockito.Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.indexesGetForLabel(org.mockito.Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.constraintsGetForLabel(org.mockito.Matchers.anyInt())).thenReturn(Collections.emptyIterator());
        Mockito.when((Object)this.read.countsForNode(org.mockito.Matchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.read.countsForRelationship(org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt(), org.mockito.Matchers.anyInt())).thenReturn((Object)1L);
        Mockito.when((Object)this.read.indexGetState((IndexDescriptor)org.mockito.Matchers.any(IndexDescriptor.class))).thenReturn((Object)InternalIndexState.ONLINE);
    }

    private Answer<Iterator<Token>> asTokens(Map<Integer, String> tokens) {
        return i -> tokens.entrySet().stream().map(entry -> new Token((String)entry.getValue(), ((Integer)entry.getKey()).intValue())).iterator();
    }

    private List<Object[]> call(String name, Object ... args) throws ProcedureException {
        CallableProcedure.BasicContext ctx = new CallableProcedure.BasicContext();
        ctx.put(CallableProcedure.Context.KERNEL_TRANSACTION, (Object)this.tx);
        return Iterators.asList((RawIterator)this.procs.call((CallableProcedure.Context)ctx, ProcedureSignature.procedureName((String[])name.split("\\.")), args));
    }
}

