/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.properties;

import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.kernel.api.properties.LazyArrayProperty;
import org.neo4j.kernel.api.properties.LazyStringProperty;

public class LazyPropertyTest {
    public static final Object[] ENPTY_ARRAYS = new Object[]{new boolean[0], new char[0], new String[0], new float[0], new double[0], new byte[0], new short[0], new int[0], new long[0]};

    @Test
    public void shouldLoadLazyStringProperty() throws Exception {
        LazyStringProperty property = new LazyStringProperty(0, LazyPropertyTest.value("person"));
        Assert.assertEquals((Object)"person", (Object)property.value());
    }

    @Test
    public void shouldLoadLazyStringPropertyOnlyOnce() throws Exception {
        LazyStringProperty property = new LazyStringProperty(0, LazyPropertyTest.value("person"));
        Assert.assertEquals((Object)"person", (Object)property.value());
        Assert.assertEquals((Object)"person", (Object)property.value());
    }

    @Test
    public void shouldExhibitCorrectEqualityForBooleanArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new boolean[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForByteArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new byte[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForShortArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new short[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForCharArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new char[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForIntArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new int[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForLongArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new long[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForFloatArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new float[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForDoubleArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new double[0]);
    }

    @Test
    public void shouldExhibitCorrectEqualityForStringArray() throws Exception {
        LazyPropertyTest.verifyCorrectValueEqualityForLazyArrayProperty(new String[0]);
    }

    private static void verifyCorrectValueEqualityForLazyArrayProperty(Object array) {
        LazyArrayProperty property = new LazyArrayProperty(0, LazyPropertyTest.value(ArrayUtil.clone((Object)array)));
        Assert.assertTrue((String)"value should be reported equal with same type", (boolean)property.valueEquals(array));
        for (Object value : ENPTY_ARRAYS) {
            if (LazyPropertyTest.coercible(value.getClass(), array.getClass())) continue;
            Assert.assertFalse((String)"value should be reported inequal with different type", (boolean)property.valueEquals(value));
        }
    }

    private static boolean coercible(Class<?> lhs, Class<?> rhs) {
        if (lhs == rhs) {
            return true;
        }
        if (lhs.isArray() && rhs.isArray()) {
            return LazyPropertyTest.coercible(lhs.getComponentType(), rhs.getComponentType());
        }
        if (lhs.isArray() || rhs.isArray()) {
            return false;
        }
        switch (lhs.getName()) {
            case "boolean": {
                return rhs == Boolean.TYPE;
            }
            case "char": 
            case "java.lang.String": {
                return rhs == Character.TYPE || rhs == String.class;
            }
            case "float": 
            case "double": 
            case "byte": 
            case "short": 
            case "int": 
            case "long": {
                return rhs == Float.TYPE || rhs == Double.TYPE || rhs == Byte.TYPE || rhs == Short.TYPE || rhs == Integer.TYPE || rhs == Long.TYPE;
            }
        }
        return false;
    }

    private static <T> Callable<T> value(final T value) {
        return new Callable<T>(){
            boolean called = false;

            @Override
            public T call() throws Exception {
                Assert.assertFalse((String)("Already called for value: " + value), (boolean)this.called);
                this.called = true;
                return value;
            }
        };
    }
}

