/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import com.google.common.collect.Sets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.test.EmbeddedDatabaseRule;
import org.neo4j.test.RepeatRule;

public class TokenCreationIT {
    @Rule
    public final EmbeddedDatabaseRule databaseRule = new EmbeddedDatabaseRule();
    private volatile boolean stop = false;

    @Test
    @RepeatRule.Repeat(times=5)
    public void concurrentLabelTokenCreation() throws InterruptedException {
        int concurrentWorkers = 10;
        CountDownLatch latch = new CountDownLatch(concurrentWorkers);
        for (int i = 0; i < concurrentWorkers; ++i) {
            new LabelCreator((GraphDatabaseService)this.databaseRule, latch).start();
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(500L));
        this.stop = true;
        latch.await();
    }

    public Label[] getLabels() {
        int randomLabelValue = ThreadLocalRandom.current().nextInt(2) + 1;
        Label[] labels = new Label[randomLabelValue];
        for (int i = 0; i < labels.length; ++i) {
            labels[i] = Label.label((String)RandomStringUtils.randomAscii((int)randomLabelValue));
        }
        return labels;
    }

    private class LabelCreator
    extends Thread {
        private final GraphDatabaseService database;
        private final CountDownLatch createLatch;

        public LabelCreator(GraphDatabaseService database, CountDownLatch createLatch) {
            this.database = database;
            this.createLatch = createLatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                while (true) {
                    if (TokenCreationIT.this.stop) break block16;
                    try {
                        Transaction transaction = this.database.beginTx();
                        Throwable throwable = null;
                        try {
                            Object[] createdLabels = TokenCreationIT.this.getLabels();
                            Node node = this.database.createNode((Label[])createdLabels);
                            Iterable nodeLabels = node.getLabels();
                            Assert.assertEquals((Object)Sets.newHashSet((Object[])createdLabels), (Object)Sets.newHashSet((Iterable)nodeLabels));
                            transaction.success();
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (transaction == null) continue;
                            if (throwable != null) {
                                try {
                                    transaction.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            transaction.close();
                        }
                    }
                    catch (Exception e) {
                        TokenCreationIT.this.stop = true;
                        throw e;
                    }
                }
                finally {
                    this.createLatch.countDown();
                }
            }
        }
    }
}

