/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.mockfs.EphemeralFileSystemAbstraction;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.factory.DataSourceModule;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.EditionModule;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.factory.PlatformModule;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;

public class GraphDatabaseFacadeFactoryTest {
    @Rule
    public final TargetDirectory.TestDirectory dir = TargetDirectory.testDirForTestWithEphemeralFS((EphemeralFileSystemAbstraction)new EphemeralFileSystemAbstraction(), this.getClass());
    private final GraphDatabaseFacade mockFacade = (GraphDatabaseFacade)Mockito.mock(GraphDatabaseFacade.class);
    private final GraphDatabaseFacadeFactory.Dependencies deps = (GraphDatabaseFacadeFactory.Dependencies)Mockito.mock(GraphDatabaseFacadeFactory.Dependencies.class, (Answer)Mockito.RETURNS_MOCKS);

    @Before
    public void setup() {
        Mockito.when((Object)this.deps.monitors()).thenReturn((Object)new Monitors());
    }

    @Test
    public void shouldThrowAppropriateExceptionIfStartFails() {
        RuntimeException startupError = new RuntimeException();
        GraphDatabaseFacadeFactory db = this.newFaultyGraphDatabaseFacadeFactory(startupError);
        try {
            db.newFacade(this.dir.graphDbDir(), Collections.emptyMap(), this.deps, this.mockFacade);
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception));
        }
    }

    @Test
    public void shouldThrowAppropriateExceptionIfBothStartAndShutdownFail() {
        RuntimeException startupError = new RuntimeException();
        RuntimeException shutdownError = new RuntimeException();
        GraphDatabaseFacadeFactory db = this.newFaultyGraphDatabaseFacadeFactory(startupError);
        ((GraphDatabaseFacade)Mockito.doThrow((Throwable)shutdownError).when((Object)this.mockFacade)).shutdown();
        try {
            db.newFacade(this.dir.graphDbDir(), Collections.emptyMap(), this.deps, this.mockFacade);
            Assert.fail((String)("Should have thrown " + RuntimeException.class));
        }
        catch (RuntimeException exception) {
            Assert.assertEquals((Object)shutdownError, (Object)exception);
            Assert.assertEquals((Object)startupError, (Object)Exceptions.rootCause((Throwable)exception.getSuppressed()[0]));
        }
    }

    private GraphDatabaseFacadeFactory newFaultyGraphDatabaseFacadeFactory(final RuntimeException startupError) {
        return new GraphDatabaseFacadeFactory(){

            protected PlatformModule createPlatform(File storeDir, Map<String, String> params, GraphDatabaseFacadeFactory.Dependencies dependencies, GraphDatabaseFacade graphDatabaseFacade) {
                final LifeSupport lifeMock = (LifeSupport)Mockito.mock(LifeSupport.class);
                ((LifeSupport)Mockito.doThrow((Throwable)startupError).when((Object)lifeMock)).start();
                ((LifeSupport)Mockito.doAnswer((Answer)new Answer(){

                    public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                        return invocationOnMock.getArguments()[0];
                    }
                }).when((Object)lifeMock)).add((Lifecycle)Matchers.any(Lifecycle.class));
                return new PlatformModule(storeDir, params, this.databaseInfo(), dependencies, graphDatabaseFacade){

                    public LifeSupport createLife() {
                        return lifeMock;
                    }
                };
            }

            protected EditionModule createEdition(PlatformModule platformModule) {
                return (EditionModule)Mockito.mock(EditionModule.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
            }

            protected DataSourceModule createDataSource(GraphDatabaseFacadeFactory.Dependencies dependencies, PlatformModule platformModule, EditionModule editionModule) {
                return null;
            }

            protected DatabaseInfo databaseInfo() {
                return DatabaseInfo.UNKNOWN;
            }
        };
    }
}

