/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.api.index.ControlledPopulationSchemaIndexProvider;
import org.neo4j.kernel.impl.api.index.SchemaIndexTestHelper;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.DoubleLatch;
import org.neo4j.test.ImpermanentDatabaseRule;
import org.neo4j.test.TestGraphDatabaseFactory;

public class SchemaIndexWaitingAcceptanceTest {
    private final ControlledPopulationSchemaIndexProvider provider = new ControlledPopulationSchemaIndexProvider();
    @Rule
    public ImpermanentDatabaseRule rule = new ImpermanentDatabaseRule(){

        @Override
        protected void configure(GraphDatabaseFactory databaseFactory) {
            List<KernelExtensionFactory<?>> extensions = Collections.singletonList(SchemaIndexTestHelper.singleInstanceSchemaIndexProviderFactory("test", SchemaIndexWaitingAcceptanceTest.this.provider));
            ((TestGraphDatabaseFactory)databaseFactory).addKernelExtensions(extensions);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWatingForIndexToComeOnline() throws Exception {
        IndexDefinition index;
        GraphDatabaseAPI db = this.rule.getGraphDatabaseAPI();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = db.beginTx();){
            index = db.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.success();
        }
        latch.awaitStart();
        try {
            tx = db.beginTx();
            var5_5 = null;
            try {
                db.schema().awaitIndexOnline(index, 1L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected IllegalStateException to be thrown");
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var5_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldTimeoutWatingForAllIndexesToComeOnline() throws Exception {
        GraphDatabaseAPI db = this.rule.getGraphDatabaseAPI();
        DoubleLatch latch = this.provider.installPopulationJobCompletionLatch();
        try (Transaction tx = db.beginTx();){
            db.schema().indexFor(Label.label((String)"Person")).on("name").create();
            tx.success();
        }
        latch.awaitStart();
        try {
            tx = db.beginTx();
            var4_5 = null;
            try {
                db.schema().awaitIndexesOnline(1L, TimeUnit.MILLISECONDS);
                Assert.fail((String)"Expected IllegalStateException to be thrown");
            }
            catch (Throwable throwable) {
                var4_5 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var4_5 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var4_5.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"come online"));
        }
        finally {
            latch.finish();
        }
    }
}

