/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.Iterators;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.EmbeddedDatabaseRule;

public class LabelScanStoreIT {
    @Rule
    public final DatabaseRule dbRule = new EmbeddedDatabaseRule();

    @Test
    public void shouldGetNodesWithCreatedLabel() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.Second);
        Node node3 = this.createLabeledNode(Labels.Third);
        Node node4 = this.createLabeledNode(Labels.First, Labels.Second, Labels.Third);
        Node node5 = this.createLabeledNode(Labels.First, Labels.Third);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.First)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2, node4}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.Second)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node3, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.Third)));
    }

    @Test
    public void shouldGetNodesWithAddedLabel() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First);
        Node node2 = this.createLabeledNode(Labels.Second);
        Node node3 = this.createLabeledNode(Labels.Third);
        Node node4 = this.createLabeledNode(Labels.First);
        Node node5 = this.createLabeledNode(Labels.First);
        this.addLabels(node4, Labels.Second, Labels.Third);
        this.addLabels(node5, Labels.Third);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.First)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2, node4}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.Second)));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node3, node4, node5}), (Object)Iterables.asSet(this.getAllNodesWithLabel(Labels.Third)));
    }

    @Test
    public void shouldGetNodesAfterDeletedNodes() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First, Labels.Second);
        Node node2 = this.createLabeledNode(Labels.First, Labels.Third);
        this.deleteNode(node1);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.First));
        Assert.assertEquals((Object)Iterators.emptySetOf(Node.class), this.getAllNodesWithLabel(Labels.Second));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.Third));
    }

    @Test
    public void shouldGetNodesAfterRemovedLabels() throws Exception {
        Node node1 = this.createLabeledNode(Labels.First, Labels.Second);
        Node node2 = this.createLabeledNode(Labels.First, Labels.Third);
        this.removeLabels(node1, Labels.First);
        this.removeLabels(node2, Labels.Third);
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node2}), this.getAllNodesWithLabel(Labels.First));
        Assert.assertEquals((Object)Iterators.asSet((Object[])new Node[]{node1}), this.getAllNodesWithLabel(Labels.Second));
        Assert.assertEquals((Object)Iterators.emptySetOf(Node.class), this.getAllNodesWithLabel(Labels.Third));
    }

    @Test
    public void retrieveNodeIdsInAscendingOrder() {
        for (int i = 0; i < 50; ++i) {
            this.createLabeledNode(Labels.First, Labels.Second);
            this.createLabeledNode(Labels.Second);
            this.createLabeledNode(Labels.First);
        }
        this.createLabeledNode(Labels.Third);
        this.verifyFoundNodes(Labels.Third, "Expect to see 1 matched nodeId: 150", 150L);
        Node nodeById = this.getNodeById(1L);
        this.addLabels(nodeById, Labels.Third);
        this.verifyFoundNodes(Labels.Third, "Expect to see 2 matched nodeIds: 1, 150", 1L, 150L);
    }

    @Test
    public void shouldHandleLargeAmountsOfNodesAddedAndRemovedInSameTx() throws Exception {
        Node node;
        GraphDatabaseAPI db = this.dbRule.getGraphDatabaseAPI();
        int labelsToAdd = 80;
        int labelsToRemove = 40;
        try (Transaction tx = db.beginTx();){
            int l;
            node = db.createNode();
            for (l = 0; l < labelsToAdd; ++l) {
                node.addLabel(Label.label((String)("Label-" + l)));
            }
            for (l = 0; l < labelsToRemove; ++l) {
                node.removeLabel(Label.label((String)("Label-" + l)));
            }
            tx.success();
        }
        var6_5 = null;
        try (Transaction ignore = db.beginTx();){
            for (int l = labelsToAdd - 1; l >= labelsToRemove; --l) {
                Label label = Label.label((String)("Label-" + l));
                Assert.assertThat((String)("Should have founnd node when looking for label " + label), (Object)Iterators.single((Iterator)db.findNodes(label)), (Matcher)CoreMatchers.equalTo((Object)node));
            }
        }
        catch (Throwable throwable) {
            var6_5 = throwable;
            throw throwable;
        }
    }

    private void verifyFoundNodes(Label label, String sizeMismatchMessage, long ... expectedNodeIds) {
        try (Transaction ignored = this.dbRule.getGraphDatabaseAPI().beginTx();){
            ResourceIterator nodes = this.dbRule.getGraphDatabaseAPI().findNodes(label);
            List nodeList = Iterators.asList((Iterator)nodes);
            Assert.assertThat((String)sizeMismatchMessage, (Object)nodeList, (Matcher)Matchers.hasSize((int)expectedNodeIds.length));
            int index = 0;
            for (Node node : nodeList) {
                Assert.assertEquals((long)expectedNodeIds[index++], (long)node.getId());
            }
        }
    }

    private void removeLabels(Node node, Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            for (Label label : labels) {
                node.removeLabel(label);
            }
            tx.success();
        }
    }

    private void deleteNode(Node node) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            node.delete();
            tx.success();
        }
    }

    private Set<Node> getAllNodesWithLabel(Label label) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Set set = Iterators.asSet((Iterator)this.dbRule.getGraphDatabaseAPI().findNodes(label));
            return set;
        }
    }

    private Node createLabeledNode(Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            Node node = this.dbRule.getGraphDatabaseAPI().createNode(labels);
            tx.success();
            Node node2 = node;
            return node2;
        }
    }

    private void addLabels(Node node, Label ... labels) {
        try (Transaction tx = this.dbRule.getGraphDatabaseAPI().beginTx();){
            for (Label label : labels) {
                node.addLabel(label);
            }
            tx.success();
        }
    }

    private Node getNodeById(long id) {
        try (Transaction ignored = this.dbRule.beginTx();){
            Node node = this.dbRule.getNodeById(id);
            return node;
        }
    }

    private static enum Labels implements Label
    {
        First,
        Second,
        Third;

    }
}

