/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.DatabaseShutdownException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.CleanupRule;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.TestGraphDatabaseFactory;

public class GraphDatabaseServiceTest {
    @Rule
    public ExpectedException exception = ExpectedException.none();
    @Rule
    public final CleanupRule cleanup = new CleanupRule();

    @Test
    public void givenShutdownDatabaseWhenBeginTxThenExceptionIsThrown() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        db.shutdown();
        this.exception.expect(DatabaseShutdownException.class);
        db.beginTx();
    }

    @Test
    public void givenDatabaseAndStartedTxWhenShutdownThenWaitForTxToFinish() throws Exception {
        final GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        final CountDownLatch started = new CountDownLatch(1);
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    started.countDown();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    db.createNode();
                    tx.success();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        started.await();
        db.shutdown();
    }

    @Test
    public void terminateTransactionThrowsExceptionOnNextOperation() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            tx.terminate();
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
        db.shutdown();
    }

    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextOperation() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();){
            try (Transaction nested = db.beginTx();){
                tx.terminate();
            }
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
        db.shutdown();
    }

    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperation() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try (Transaction tx = db.beginTx();
             Transaction nested = db.beginTx();){
            tx.terminate();
            try {
                db.createNode();
                Assert.fail((String)"Failed to throw TransactionTerminateException");
            }
            catch (TransactionTerminatedException transactionTerminatedException) {
                // empty catch block
            }
        }
        db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperationMultiThreadedVersion() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            CountDownLatch txSet = new CountDownLatch(1);
            CountDownLatch terminated = new CountDownLatch(1);
            Transaction[] outer = new Transaction[]{null};
            Exception[] threadFail = new Exception[]{null};
            Thread worker = new Thread(() -> {
                try (Transaction inner = db.beginTx();){
                    outer[0] = inner;
                    txSet.countDown();
                    terminated.await();
                    db.createNode();
                    Assert.fail((String)"should have failed earlier");
                }
                catch (Exception e) {
                    threadFail[0] = e;
                }
            });
            worker.start();
            txSet.await();
            outer[0].terminate();
            terminated.countDown();
            worker.join();
            Assert.assertThat((Object)threadFail[0], (Matcher)CoreMatchers.instanceOf(TransactionTerminatedException.class));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void terminateNestedTransactionThrowsExceptionOnNextNestedOperationMultiThreadedVersionWithNestedTx() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        try {
            CountDownLatch txSet = new CountDownLatch(1);
            CountDownLatch terminated = new CountDownLatch(1);
            Transaction[] outer = new Transaction[]{null};
            Exception[] threadFail = new Exception[]{null};
            Thread worker = new Thread(() -> {
                try (Transaction transaction = db.beginTx();
                     Transaction inner = db.beginTx();){
                    outer[0] = inner;
                    txSet.countDown();
                    terminated.await();
                    db.createNode();
                    Assert.fail((String)"should have failed earlier");
                }
            });
            worker.start();
            txSet.await();
            outer[0].terminate();
            terminated.countDown();
            worker.join();
            Assert.assertThat((Object)threadFail[0], (Matcher)CoreMatchers.instanceOf(TransactionTerminatedException.class));
        }
        finally {
            db.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void givenDatabaseAndStartedTxWhenShutdownAndStartNewTxThenBeginTxTimesOut() throws Exception {
        final GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        final CountDownLatch shutdown = new CountDownLatch(1);
        final AtomicReference result = new AtomicReference();
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try (Transaction tx = db.beginTx();){
                    shutdown.countDown();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    db.createNode();
                    tx.success();
                    Executors.newSingleThreadExecutor().submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                db.beginTx();
                                result.set(Boolean.TRUE);
                            }
                            catch (Exception e) {
                                result.set(e);
                            }
                            AtomicReference atomicReference = result;
                            synchronized (atomicReference) {
                                result.notifyAll();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
        shutdown.await();
        db.shutdown();
        while (result.get() == null) {
            AtomicReference atomicReference = result;
            synchronized (atomicReference) {
                result.wait(100L);
            }
        }
        Assert.assertThat(result.get(), (Matcher)CoreMatchers.instanceOf(DatabaseShutdownException.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldLetDetectedDeadlocksDuringCommitBeThrownInTheirOriginalForm() throws Exception {
        GraphDatabaseService db = this.cleanup.add(new TestGraphDatabaseFactory().newImpermanentDatabase());
        Node n1 = this.createNode(db);
        Node n2 = this.createNode(db);
        Relationship r3 = this.createRelationship(n1);
        Relationship r2 = this.createRelationship(n1);
        Relationship r1 = this.createRelationship(n1);
        OtherThreadExecutor<Object> t2 = this.cleanup.add(new OtherThreadExecutor<Object>("T2", null));
        Transaction t1Tx = db.beginTx();
        Transaction t2Tx = t2.execute(this.beginTx(db));
        n2.setProperty("locked", (Object)"indeed");
        t2.execute(this.setProperty((PropertyContainer)r1, "locked", "absolutely"));
        Future<Object> t2n2Wait = t2.executeDontWait(this.setProperty((PropertyContainer)n2, "locked", "In my dreams"));
        t2.waitUntilWaiting();
        r2.delete();
        t1Tx.success();
        try {
            t1Tx.close();
            Assert.fail((String)"Should throw exception about deadlock");
        }
        catch (Exception e) {
            Assert.assertEquals(DeadlockDetectedException.class, e.getClass());
        }
        finally {
            t2n2Wait.get();
            t2.execute(this.close(t2Tx));
            t2.close();
        }
    }

    @Test
    public void terminationOfClosedTransactionDoesNotInfluenceNextTransaction() {
        Transaction transaction;
        GraphDatabaseService db = this.cleanup.add(new TestGraphDatabaseFactory().newImpermanentDatabase());
        try (Transaction tx = db.beginTx();){
            db.createNode();
            tx.success();
        }
        try (Transaction tx = transaction = db.beginTx();){
            db.createNode();
            tx.success();
        }
        transaction.terminate();
        tx = db.beginTx();
        var4_6 = null;
        try {
            Assert.assertThat((Object)db.getAllNodes(), (Matcher)Matchers.is((Matcher)Matchers.iterableWithSize((int)2)));
            tx.success();
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (var4_6 != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
    }

    private OtherThreadExecutor.WorkerCommand<Void, Transaction> beginTx(final GraphDatabaseService db) {
        return new OtherThreadExecutor.WorkerCommand<Void, Transaction>(){

            @Override
            public Transaction doWork(Void state) throws Exception {
                return db.beginTx();
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Object> setProperty(final PropertyContainer entity, final String key, final String value) {
        return new OtherThreadExecutor.WorkerCommand<Void, Object>(){

            @Override
            public Object doWork(Void state) throws Exception {
                entity.setProperty(key, (Object)value);
                return null;
            }
        };
    }

    private OtherThreadExecutor.WorkerCommand<Void, Void> close(final Transaction tx) {
        return new OtherThreadExecutor.WorkerCommand<Void, Void>(){

            @Override
            public Void doWork(Void state) throws Exception {
                tx.close();
                return null;
            }
        };
    }

    private Relationship createRelationship(Node node) {
        try (Transaction tx = node.getGraphDatabase().beginTx();){
            Relationship rel = node.createRelationshipTo(node, (RelationshipType)MyRelTypes.TEST);
            tx.success();
            Relationship relationship = rel;
            return relationship;
        }
    }

    private Node createNode(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            Node node = db.createNode();
            tx.success();
            Node node2 = node;
            return node2;
        }
    }
}

