/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;

public class DeleteNodeWithRelsIT {
    @Rule
    public ImpermanentDatabaseRule db = new ImpermanentDatabaseRule();
    @Rule
    public ExpectedException exception = ExpectedException.none();

    @Test
    public void shouldGiveHelpfulExceptionWhenDeletingNodeWithRels() throws Exception {
        Node node;
        GraphDatabaseAPI db = this.db.getGraphDatabaseAPI();
        try (Transaction tx = db.beginTx();){
            node = db.createNode();
            node.createRelationshipTo(db.createNode(), (RelationshipType)DynamicRelationshipType.withName((String)"MAYOR_OF"));
            tx.success();
        }
        tx = db.beginTx();
        node.delete();
        tx.success();
        this.exception.expect(ConstraintViolationException.class);
        this.exception.expectMessage("Cannot delete node<" + node.getId() + ">, because it still has relationships. " + "To delete this node, you must first delete its relationships.");
        tx.close();
    }
}

