/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb;

import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.ImpermanentDatabaseRule;

public class CreateAndDeleteNodesIT {
    @Rule
    public ImpermanentDatabaseRule dbRule = new ImpermanentDatabaseRule();

    @Test
    public void addingALabelUsingAValidIdentifierShouldSucceed() throws Exception {
        GraphDatabaseAPI dataBase = this.dbRule.getGraphDatabaseAPI();
        try (Transaction bobTransaction = dataBase.beginTx();){
            Node myNode = dataBase.createNode();
            myNode.setProperty("Name", (Object)"Bob");
            myNode.createRelationshipTo(dataBase.createNode(), (RelationshipType)RelTypes.ASD);
            bobTransaction.success();
        }
        var4_3 = null;
        try (Transaction tx2 = dataBase.beginTx();){
            for (Relationship r : dataBase.getAllRelationships()) {
                r.delete();
            }
            for (Node n : dataBase.getAllNodes()) {
                n.delete();
            }
            tx2.success();
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    static enum RelTypes implements RelationshipType
    {
        ASD;

    }
}

