/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.File;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.test.BatchTransaction;
import org.neo4j.test.EmbeddedDatabaseRule;

@Ignore(value="Not a test. Here for show-off purposes")
public class CreateAndLoadDenseNodeIT {
    @Rule
    public EmbeddedDatabaseRule dbRule = new EmbeddedDatabaseRule(this.getClass());
    private GraphDatabaseService db;

    @Test
    public void loadSpecificTypeDirectionRelationshipsFast() throws Exception {
        Node node;
        try (Transaction tx = this.db.beginTx();){
            node = this.db.getNodeById(0L);
            tx.success();
        }
        this.loadRelationships(node, MyRelTypes.TEST, Direction.INCOMING);
        this.loadRelationships(node, MyRelTypes.TEST2, Direction.OUTGOING);
        this.loadRelationships(node, MyRelTypes.TEST_TRAVERSAL, Direction.INCOMING);
    }

    private long loadRelationships(Node node, RelationshipType type, Direction direction) {
        long count;
        try (Transaction tx = this.db.beginTx();){
            count = Iterables.count((Iterable)node.getRelationships(type, direction));
            int pCount = node.getDegree(type, direction);
            Assert.assertEquals((long)count, (long)pCount);
            tx.success();
        }
        return count;
    }

    @Before
    public void before() {
        this.createDbIfNecessary();
        this.dbRule.setConfig(GraphDatabaseSettings.allow_store_upgrade, "true");
        this.db = this.dbRule.getGraphDatabaseAPI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDbIfNecessary() {
        if (!new File(this.dbRule.getStoreDir(), "neostore").exists()) {
            this.db = this.dbRule.getGraphDatabaseAPI();
            try (BatchTransaction tx = BatchTransaction.beginBatchTx(this.db);){
                Node node = this.db.createNode();
                this.createRelationships(tx, node, MyRelTypes.TEST, Direction.INCOMING, 1);
                this.createRelationships(tx, node, MyRelTypes.TEST, Direction.OUTGOING, 3000000);
                this.createRelationships(tx, node, MyRelTypes.TEST2, Direction.OUTGOING, 5);
                this.createRelationships(tx, node, MyRelTypes.TEST2, Direction.BOTH, 5);
                this.createRelationships(tx, node, MyRelTypes.TEST_TRAVERSAL, Direction.OUTGOING, 2000000);
                this.createRelationships(tx, node, MyRelTypes.TEST_TRAVERSAL, Direction.INCOMING, 2);
            }
            finally {
                this.dbRule.shutdownAndKeepStore();
            }
        }
    }

    private void createRelationships(BatchTransaction tx, Node node, RelationshipType type, Direction direction, int count) {
        for (int i = 0; i < count; ++i) {
            Node firstNode = direction == Direction.OUTGOING || direction == Direction.BOTH ? node : this.db.createNode();
            Node otherNode = direction == Direction.INCOMING || direction == Direction.BOTH ? node : this.db.createNode();
            firstNode.createRelationshipTo(otherNode, type);
            tx.increment();
        }
    }
}

