/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.StoreVersionIdentifier;

public class StoreId
extends StoreVersionIdentifier {
    public static final StoreId UNKNOWN = new StoreId(0L, 0L, "", "", 0, 0);
    private final long creationTime;
    private final long random;
    private final String versionString;

    public StoreId(long creationTime, long random, String storageEngineName, String formatName, int majorVersion, int minorVersion) {
        this(creationTime, random, storageEngineName, formatName, majorVersion, minorVersion, null);
    }

    public StoreId(long creationTime, long random, String storageEngineName, String formatName, int majorVersion, int minorVersion, String versionString) {
        super(storageEngineName, formatName, majorVersion, minorVersion);
        this.creationTime = creationTime;
        this.random = random;
        this.versionString = versionString;
    }

    @Override
    public String getStoreVersionUserString() {
        return StringUtils.defaultString((String)this.versionString, (String)super.getStoreVersionUserString());
    }

    public static StoreId generateNew(String storageEngineName, String formatName, int majorVersion, int minorVersion) {
        return new StoreId(System.currentTimeMillis(), new SecureRandom().nextLong(), storageEngineName, formatName, majorVersion, minorVersion);
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public long getRandom() {
        return this.random;
    }

    public void serialize(WritableChannel channel) throws IOException {
        StoreIdSerialization.serialize(this, channel);
    }

    public boolean isSameOrUpgradeSuccessor(StoreId anotherId) {
        return this.creationTime == anotherId.creationTime && this.random == anotherId.random && super.isSameOrUpgradeSuccessor(anotherId);
    }

    public boolean isStoreVersionFullySupportedLocally() {
        Optional<StorageEngineFactory> maybeStorageEngine = StorageEngineFactory.allAvailableStorageEngines().stream().filter(e -> e.name().equals(this.getStorageEngineName())).findAny();
        return maybeStorageEngine.flatMap(engineFactory -> engineFactory.versionInformation(this)).map(storeVersion -> !storeVersion.onlyForMigration()).orElse(false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreId storeId = (StoreId)o;
        return this.creationTime == storeId.creationTime && this.random == storeId.random && this.getMajorVersion() == storeId.getMajorVersion() && this.getMinorVersion() == storeId.getMinorVersion() && this.getStorageEngineName().equals(storeId.getStorageEngineName()) && this.getFormatName().equals(storeId.getFormatName());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.creationTime, this.random, this.getStorageEngineName(), this.getFormatName(), this.getMajorVersion(), this.getMinorVersion());
    }

    public String toString() {
        return "StoreId{creationTime=" + this.creationTime + ", random=" + this.random + ", storageEngineName='" + this.getStorageEngineName() + "', formatName='" + this.getFormatName() + "', majorVersion=" + this.getMajorVersion() + ", minorVersion=" + this.getMinorVersion() + "}";
    }

    public static StoreId deserialize(ReadableChannel channel) throws IOException {
        return StoreIdSerialization.deserialize(channel);
    }

    public static StoreId retrieveFromStore(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        Optional<StorageEngineFactory> maybeEngine = StorageEngineFactory.selectStorageEngine(fs, databaseLayout);
        if (maybeEngine.isEmpty()) {
            return null;
        }
        return maybeEngine.get().retrieveStoreId(fs, databaseLayout, pageCache, cursorContext);
    }
}

