/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.graphdb.Direction;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RelationshipDirection {
    OUTGOING(0){

        @Override
        public boolean matches(Direction direction) {
            return direction != Direction.INCOMING;
        }
    }
    ,
    INCOMING(1){

        @Override
        public boolean matches(Direction direction) {
            return direction != Direction.OUTGOING;
        }
    }
    ,
    LOOP(2){

        @Override
        public boolean matches(Direction direction) {
            return true;
        }
    };

    private static final RelationshipDirection[] DIRECTIONS_BY_ID;
    private final int id;

    public static RelationshipDirection ofId(int id) {
        return DIRECTIONS_BY_ID[id];
    }

    public static RelationshipDirection directionOfStrict(long nodeReference, long sourceNodeReference, long targetNodeReference) {
        if (sourceNodeReference == nodeReference) {
            return targetNodeReference == nodeReference ? LOOP : OUTGOING;
        }
        if (targetNodeReference == nodeReference) {
            return INCOMING;
        }
        throw new IllegalStateException("Traversed relationship that wasn't part of the origin node:" + nodeReference + ". The encountered relationship has source:" + sourceNodeReference + " and target:" + targetNodeReference);
    }

    private RelationshipDirection(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public abstract boolean matches(Direction var1);

    static {
        DIRECTIONS_BY_ID = new RelationshipDirection[]{OUTGOING, INCOMING, LOOP};
    }
}

