/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

public enum ConnectorType {
    BOLT(0, "bolt"),
    INTRA_BOLT(1, "bolt-internal"),
    HTTP(2, "http"),
    HTTPS(3, "https"),
    PROMETHEUS(4, "prometheus"),
    RAFT(5, "raft-server"),
    CLUSTER(6, "catchup-server"),
    BACKUP(7, "backup-server");

    private final byte code;
    private final String description;

    private ConnectorType(int code, String description) {
        this.code = (byte)code;
        this.description = description;
    }

    public static ConnectorType forCode(byte code) {
        for (ConnectorType value : ConnectorType.values()) {
            if (value.code != code) continue;
            return value;
        }
        throw new IllegalArgumentException("Invalid code for ConnectorType: " + code);
    }

    public String description() {
        return this.description;
    }

    public byte code() {
        return this.code;
    }
}

