/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v44;

import java.time.Duration;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.BoltProtocolVersion;
import org.neo4j.bolt.messaging.BoltRequestMessageReader;
import org.neo4j.bolt.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.bolt.runtime.BoltConnectionFactory;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineFactory;
import org.neo4j.bolt.transport.AbstractBoltProtocol;
import org.neo4j.bolt.transport.TransportThrottleGroup;
import org.neo4j.bolt.transport.pipeline.ChannelProtector;
import org.neo4j.bolt.v41.messaging.BoltResponseMessageWriterV41;
import org.neo4j.bolt.v44.messaging.BoltRequestMessageReaderV44;
import org.neo4j.configuration.Config;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.time.SystemNanoClock;

public class BoltProtocolV44
extends AbstractBoltProtocol {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(4, 4);
    private final SystemNanoClock clock;
    private final Duration keepAliveInterval;

    public BoltProtocolV44(BoltChannel channel, BoltConnectionFactory connectionFactory, BoltStateMachineFactory stateMachineFactory, Config config, BookmarksParser bookmarksParser, LogService logging, TransportThrottleGroup throttleGroup, SystemNanoClock clock, Duration keepAliveInterval, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        super(channel, connectionFactory, stateMachineFactory, config, bookmarksParser, logging, throttleGroup, channelProtector, memoryTracker);
        this.clock = clock;
        this.keepAliveInterval = keepAliveInterval;
    }

    @Override
    protected BoltRequestMessageReader createMessageReader(BoltConnection connection, BoltResponseMessageWriter messageWriter, BookmarksParser bookmarksParser, LogService logging, ChannelProtector channelProtector, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(BoltRequestMessageReaderV44.SHALLOW_SIZE);
        return new BoltRequestMessageReaderV44(connection, messageWriter, bookmarksParser, channelProtector, logging);
    }

    @Override
    protected BoltResponseMessageWriter createMessageWriter(Neo4jPack neo4jPack, LogService logging, MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(BoltResponseMessageWriterV41.SHALLOW_SIZE);
        return new BoltResponseMessageWriterV41(neo4jPack, this.createPackOutput(memoryTracker), logging, this.clock, this.keepAliveInterval);
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

