/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v3.messaging.decoder;

import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import org.neo4j.bolt.messaging.BoltIOException;
import org.neo4j.bolt.messaging.RequestMessage;
import org.neo4j.bolt.messaging.RequestMessageDecoder;
import org.neo4j.bolt.packstream.Neo4jPack;
import org.neo4j.bolt.runtime.AccessMode;
import org.neo4j.bolt.runtime.BoltResponseHandler;
import org.neo4j.bolt.runtime.Bookmark;
import org.neo4j.bolt.runtime.BookmarksParser;
import org.neo4j.bolt.v3.messaging.request.MessageMetadataParser;
import org.neo4j.bolt.v3.messaging.request.RunMessage;
import org.neo4j.bolt.v3.runtime.bookmarking.BookmarksParserV3;
import org.neo4j.values.virtual.MapValue;

public class RunMessageDecoder
implements RequestMessageDecoder {
    private final BoltResponseHandler responseHandler;
    private final BookmarksParser bookmarksParser;

    public RunMessageDecoder(BoltResponseHandler responseHandler) {
        this(responseHandler, BookmarksParserV3.INSTANCE);
    }

    protected RunMessageDecoder(BoltResponseHandler responseHandler, BookmarksParser bookmarksParser) {
        this.responseHandler = responseHandler;
        this.bookmarksParser = bookmarksParser;
    }

    @Override
    public int signature() {
        return 16;
    }

    @Override
    public BoltResponseHandler responseHandler() {
        return this.responseHandler;
    }

    @Override
    public RequestMessage decode(Neo4jPack.Unpacker unpacker) throws IOException {
        String statement = unpacker.unpackString();
        MapValue params = unpacker.unpackMap();
        MapValue metadata = unpacker.unpackMap();
        List<Bookmark> bookmarks = this.bookmarksParser.parseBookmarks(metadata);
        Duration txTimeout = MessageMetadataParser.parseTransactionTimeout(metadata);
        AccessMode accessMode = MessageMetadataParser.parseAccessMode(metadata);
        Map<String, Object> txMetadata = MessageMetadataParser.parseTransactionMetadata(metadata);
        return this.newRunMessage(statement, params, metadata, bookmarks, txTimeout, accessMode, txMetadata);
    }

    protected RequestMessage newRunMessage(String statement, MapValue params, MapValue meta, List<Bookmark> bookmarks, Duration txTimeout, AccessMode accessMode, Map<String, Object> txMetadata) throws BoltIOException {
        return new RunMessage(statement, params, meta, bookmarks, txTimeout, accessMode, txMetadata);
    }
}

