/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport.pipeline;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.bolt.runtime.BoltConnection;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.logging.Log;
import org.neo4j.memory.HeapEstimator;

public class HouseKeeper
extends ChannelInboundHandlerAdapter {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HouseKeeper.class);
    private final BoltConnection connection;
    private final Log log;
    private boolean failed;

    public HouseKeeper(BoltConnection connection, Log log) {
        this.connection = connection;
        this.log = log;
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.connection.stop();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.failed || HouseKeeper.isShuttingDown(ctx)) {
            return;
        }
        this.failed = true;
        try {
            if (Exceptions.contains((Throwable)cause, e -> e.getMessage() != null && e.getMessage().contains("Connection reset by peer"))) {
                this.log.warn("Fatal error occurred when handling a client connection, remote peer unexpectedly closed connection: %s", new Object[]{ctx.channel()});
            } else {
                this.log.error("Fatal error occurred when handling a client connection: " + ctx.channel(), cause);
            }
        }
        finally {
            ctx.close();
        }
    }

    private static boolean isShuttingDown(ChannelHandlerContext ctx) {
        EventExecutorGroup eventLoopGroup = ctx.executor().parent();
        return eventLoopGroup != null && eventLoopGroup.isShuttingDown();
    }
}

