/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.runtime.statemachine.impl;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.runtime.BoltConnectionFatality;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachine;
import org.neo4j.bolt.runtime.statemachine.BoltStateMachineSPI;
import org.neo4j.bolt.runtime.statemachine.MutableConnectionState;
import org.neo4j.bolt.runtime.statemachine.StateMachineContext;
import org.neo4j.bolt.runtime.statemachine.StatementProcessorReleaseManager;
import org.neo4j.bolt.runtime.statemachine.TransactionStateMachineSPIProvider;
import org.neo4j.bolt.runtime.statemachine.impl.StatementProcessorProvider;
import org.neo4j.bolt.transaction.CleanUpTransactionContext;
import org.neo4j.bolt.transaction.InitializeContext;
import org.neo4j.bolt.transaction.TransactionManager;
import org.neo4j.bolt.v41.messaging.RoutingContext;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;

public class BoltStateMachineContextImpl
implements StateMachineContext,
StatementProcessorReleaseManager {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(BoltStateMachineContextImpl.class);
    private final BoltStateMachine machine;
    private final BoltChannel boltChannel;
    private final BoltStateMachineSPI spi;
    private final MutableConnectionState connectionState;
    private final Clock clock;
    private final DefaultDatabaseResolver defaultDatabaseResolver;
    private final TransactionManager transactionManager;
    private final MemoryTracker memoryTracker;
    private String defaultDatabase;
    private LoginContext primaryLoginContext;
    private String impersonatedUser;
    private LoginContext impersonationLoginContext;

    public BoltStateMachineContextImpl(BoltStateMachine machine, BoltChannel boltChannel, BoltStateMachineSPI spi, MutableConnectionState connectionState, Clock clock, DefaultDatabaseResolver defaultDatabaseResolver, MemoryTracker memoryTracker, TransactionManager transactionManager) {
        this.machine = machine;
        this.boltChannel = boltChannel;
        this.spi = spi;
        this.connectionState = connectionState;
        this.clock = clock;
        this.memoryTracker = memoryTracker;
        this.defaultDatabaseResolver = defaultDatabaseResolver;
        this.transactionManager = transactionManager;
    }

    @Override
    public void authenticatedAsUser(LoginContext loginContext, String userAgent) {
        this.primaryLoginContext = loginContext;
        this.boltChannel.updateUser(loginContext.subject().authenticatedUser(), userAgent);
        this.resolveDefaultDatabase();
    }

    @Override
    public void impersonateUser(LoginContext loginContext) {
        this.impersonationLoginContext = loginContext;
        this.resolveDefaultDatabase();
    }

    @Override
    public LoginContext getLoginContext() {
        if (this.impersonationLoginContext != null) {
            return this.impersonationLoginContext;
        }
        return this.primaryLoginContext;
    }

    private void resolveDefaultDatabase() {
        String defaultDatabase;
        this.defaultDatabase = defaultDatabase = this.defaultDatabaseResolver.defaultDatabase(this.getLoginContext().subject().executingUser());
        this.boltChannel.updateDefaultDatabase(defaultDatabase);
    }

    @Override
    public void handleFailure(Throwable cause, boolean fatal) throws BoltConnectionFatality {
        this.machine.handleFailure(cause, fatal);
    }

    @Override
    public boolean resetMachine() throws BoltConnectionFatality {
        return this.machine.reset();
    }

    @Override
    public BoltStateMachineSPI boltSpi() {
        return this.spi;
    }

    @Override
    public MutableConnectionState connectionState() {
        return this.connectionState;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public String connectionId() {
        return this.machine.id();
    }

    @Override
    public void initStatementProcessorProvider(RoutingContext routingContext) {
        TransactionStateMachineSPIProvider transactionSpiProvider = this.spi.transactionStateMachineSPIProvider();
        StatementProcessorProvider statementProcessorProvider = new StatementProcessorProvider(transactionSpiProvider, this.clock, this, routingContext, this.memoryTracker);
        InitializeContext initializeContext = new InitializeContext(this.connectionId(), statementProcessorProvider);
        this.transactionManager.initialize(initializeContext);
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public String getDefaultDatabase() {
        return this.defaultDatabase;
    }

    @Override
    public void releaseStatementProcessor(String transactionId) {
        this.transactionManager.cleanUp(new CleanUpTransactionContext(transactionId));
        this.connectionState.clearCurrentTransactionId();
    }
}

