/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.transport.BoltMessagingProtocolHandler;
import org.neo4j.bolt.v1.messaging.BoltMessageRouter;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageWriter;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.transport.BoltV1Dechunker;
import org.neo4j.bolt.v1.transport.ChunkedOutput;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

public class BoltMessagingProtocolV1Handler
implements BoltMessagingProtocolHandler {
    public static final int VERSION = 1;
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 8192;
    private final ChunkedOutput chunkedOutput;
    private final BoltResponseMessageWriter packer;
    private final BoltV1Dechunker dechunker;
    private final BoltWorker worker;
    private final AtomicInteger inFlight = new AtomicInteger(0);
    private final Log internalLog;

    public BoltMessagingProtocolV1Handler(BoltChannel boltChannel, BoltWorker worker, LogService logging) {
        this.chunkedOutput = new ChunkedOutput(boltChannel.rawChannel(), 8192);
        this.packer = new BoltResponseMessageWriter(new Neo4jPack.Packer(this.chunkedOutput), this.chunkedOutput, boltChannel.log());
        this.worker = worker;
        this.internalLog = logging.getInternalLog(this.getClass());
        this.dechunker = new BoltV1Dechunker(new BoltMessageRouter(this.internalLog, boltChannel.log(), worker, this.packer, this::onMessageDone), this::onMessageStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(ChannelHandlerContext channelContext, ByteBuf data) throws IOException {
        try {
            this.dechunker.handle(data);
        }
        catch (Throwable t) {
            this.internalLog.error("Failed to handle incoming Bolt message. Connection will be closed.", t);
            this.worker.halt();
        }
        finally {
            data.release();
        }
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public synchronized void close() {
        this.dechunker.close();
        this.worker.halt();
        this.chunkedOutput.close();
    }

    private void onMessageStarted() {
        this.inFlight.incrementAndGet();
    }

    private void onMessageDone() {
        if (this.inFlight.decrementAndGet() == 0 && !this.dechunker.isInMiddleOfAMessage()) {
            try {
                this.packer.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

