/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.concurrent;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.BoltWorkerQueueMonitor;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.bolt.v1.runtime.concurrent.RunnableBoltWorker;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.scheduler.JobScheduler;

public class ThreadedWorkerFactory
implements WorkerFactory {
    private final BoltFactory connector;
    private final JobScheduler scheduler;
    private final LogService logging;
    private final Clock clock;

    public ThreadedWorkerFactory(BoltFactory connector, JobScheduler scheduler, LogService logging, Clock clock) {
        this.connector = connector;
        this.scheduler = scheduler;
        this.logging = logging;
        this.clock = clock;
    }

    @Override
    public BoltWorker newWorker(BoltChannel boltChannel, BoltWorkerQueueMonitor queueMonitor) {
        BoltStateMachine machine = this.connector.newMachine(boltChannel, this.clock);
        RunnableBoltWorker worker = new RunnableBoltWorker(machine, this.logging, queueMonitor);
        this.scheduler.schedule(JobScheduler.Groups.sessionWorker, (Runnable)worker, MapUtil.stringMap((String[])new String[]{"thread-id", machine.key()}));
        return worker;
    }
}

