/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.neo4j.bolt.v1.runtime.BoltConnectionAuthFatality;
import org.neo4j.bolt.v1.runtime.BoltConnectionFatality;
import org.neo4j.bolt.v1.runtime.BoltProtocolBreachFatality;
import org.neo4j.bolt.v1.runtime.BoltStateMachine;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.BoltWorkerQueueMonitor;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.logging.Log;

class RunnableBoltWorker
implements Runnable,
BoltWorker {
    private static final int workQueueMaxBatchSize = Integer.getInteger("org.neo4j.bolt.workQueueMaxBatchSize", 100);
    static final int workQueuePollDuration = Integer.getInteger("org.neo4j.bolt.workQueuePollDuration", 10);
    private final BlockingQueue<Job> jobQueue = new LinkedBlockingQueue<Job>();
    private final BoltStateMachine machine;
    private final Log log;
    private final Log userLog;
    private final BoltWorkerQueueMonitor queueMonitor;
    private volatile boolean keepRunning = true;

    RunnableBoltWorker(BoltStateMachine machine, LogService logging) {
        this(machine, logging, null);
    }

    RunnableBoltWorker(BoltStateMachine machine, LogService logging, BoltWorkerQueueMonitor queueMonitor) {
        this.machine = machine;
        this.log = logging.getInternalLog(this.getClass());
        this.userLog = logging.getUserLog(this.getClass());
        this.queueMonitor = queueMonitor;
    }

    @Override
    public void enqueue(Job job) {
        try {
            this.jobQueue.put(job);
            this.notifyEnqueued(job);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Worker interrupted while queueing request, the session may have been forcibly closed, or the database may be shutting down.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        ArrayList<Job> batch = new ArrayList<Job>(workQueueMaxBatchSize);
        try {
            block10: while (this.keepRunning) {
                Job job = this.jobQueue.poll(workQueuePollDuration, TimeUnit.SECONDS);
                if (job != null) {
                    this.notifyDequeued(job);
                    this.execute(job);
                    int jobCount = this.jobQueue.drainTo(batch, workQueueMaxBatchSize);
                    while (true) {
                        if (!this.keepRunning || jobCount <= 0) continue block10;
                        this.notifyDrained(batch);
                        this.executeBatch(batch);
                        jobCount = this.jobQueue.drainTo(batch, workQueueMaxBatchSize);
                    }
                }
                this.machine.validateTransaction();
            }
            return;
        }
        catch (BoltConnectionAuthFatality job) {
            return;
        }
        catch (BoltProtocolBreachFatality e) {
            this.log.error("Bolt protocol breach in session '" + this.machine.key() + "'", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            this.log.info("Worker for session '" + this.machine.key() + "' interrupted probably due to server shutdown.");
            return;
        }
        catch (Throwable t) {
            this.userLog.error("Worker for session '" + this.machine.key() + "' crashed.", t);
            return;
        }
        finally {
            this.closeStateMachine();
        }
    }

    private void executeBatch(List<Job> batch) throws BoltConnectionFatality {
        for (int i = 0; this.keepRunning && i < batch.size(); ++i) {
            this.execute(batch.get(i));
        }
        batch.clear();
    }

    private void execute(Job job) throws BoltConnectionFatality {
        job.perform(this.machine);
    }

    @Override
    public void interrupt() {
        this.machine.interrupt();
    }

    @Override
    public void halt() {
        try {
            this.machine.terminate();
        }
        finally {
            this.keepRunning = false;
        }
    }

    private void closeStateMachine() {
        try {
            this.machine.close();
        }
        catch (Throwable t) {
            this.log.error("Unable to close Bolt session '" + this.machine.key() + "'", t);
        }
    }

    private void notifyEnqueued(Job job) {
        if (this.queueMonitor != null) {
            this.queueMonitor.enqueued(job);
        }
    }

    private void notifyDequeued(Job job) {
        if (this.queueMonitor != null) {
            this.queueMonitor.dequeued(job);
        }
    }

    private void notifyDrained(List<Job> jobs) {
        if (this.queueMonitor != null) {
            this.queueMonitor.drained(jobs);
        }
    }
}

