/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.runtime;

import java.time.Clock;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.BoltWorkerQueueMonitor;
import org.neo4j.bolt.v1.runtime.Job;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredWorkerFactory
implements WorkerFactory {
    private final SessionMonitor monitor;
    private final WorkerFactory delegate;
    private final Clock clock;
    private final Monitors monitors;

    public MonitoredWorkerFactory(Monitors monitors, WorkerFactory delegate, Clock clock) {
        this.delegate = delegate;
        this.clock = clock;
        this.monitors = monitors;
        this.monitor = (SessionMonitor)this.monitors.newMonitor(SessionMonitor.class, new String[0]);
    }

    @Override
    public BoltWorker newWorker(BoltChannel boltChannel, BoltWorkerQueueMonitor queueMonitor) {
        if (this.monitors.hasListeners(SessionMonitor.class)) {
            return new MonitoredBoltWorker(this.monitor, this.delegate.newWorker(boltChannel), this.clock);
        }
        return this.delegate.newWorker(boltChannel, queueMonitor);
    }

    public static interface SessionMonitor {
        public void sessionStarted();

        public void messageReceived();

        public void processingStarted(long var1);

        public void processingDone(long var1);
    }

    static class MonitoredBoltWorker
    implements BoltWorker {
        private final SessionMonitor monitor;
        private final BoltWorker delegate;
        private final Clock clock;

        MonitoredBoltWorker(SessionMonitor monitor, BoltWorker delegate, Clock clock) {
            this.monitor = monitor;
            this.delegate = delegate;
            this.clock = clock;
            this.monitor.sessionStarted();
        }

        @Override
        public void enqueue(Job job) {
            this.monitor.messageReceived();
            long start = this.clock.millis();
            this.delegate.enqueue(session -> {
                long queueTime = this.clock.millis() - start;
                this.monitor.processingStarted(queueTime);
                job.perform(session);
                this.monitor.processingDone(this.clock.millis() - start - queueTime);
            });
        }

        @Override
        public void interrupt() {
            this.delegate.interrupt();
        }

        @Override
        public void halt() {
            this.delegate.halt();
        }
    }
}

