/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.neo4j.bolt.v1.messaging.BoltIOException;
import org.neo4j.bolt.v1.messaging.BoltRequestMessage;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.Neo4jPack;
import org.neo4j.bolt.v1.packstream.PackStream;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.virtual.MapValue;

public class BoltRequestMessageReader {
    private final Neo4jPack.Unpacker unpacker;

    public BoltRequestMessageReader(Neo4jPack.Unpacker unpacker) {
        this.unpacker = unpacker;
    }

    public boolean hasNext() throws IOException {
        return this.unpacker.hasNext();
    }

    public <E extends Exception> void read(BoltRequestMessageHandler<E> handler) throws IOException, E {
        try {
            this.unpacker.unpackStructHeader();
            char signature = this.unpacker.unpackStructSignature();
            BoltRequestMessage message = BoltRequestMessage.withSignature(signature);
            try {
                switch (message) {
                    case INIT: {
                        String clientName = this.unpacker.unpackString();
                        Map<String, Object> credentials = this.unpacker.unpackToRawMap();
                        handler.onInit(clientName, credentials);
                        break;
                    }
                    case ACK_FAILURE: {
                        handler.onAckFailure();
                        break;
                    }
                    case RESET: {
                        handler.onReset();
                        break;
                    }
                    case RUN: {
                        String statement = this.unpacker.unpackString();
                        MapValue params = this.unpacker.unpackMap();
                        Optional<Neo4jError> error = this.unpacker.consumeError();
                        if (error.isPresent()) {
                            handler.onExternalError(error.get());
                            break;
                        }
                        handler.onRun(statement, params);
                        break;
                    }
                    case DISCARD_ALL: {
                        handler.onDiscardAll();
                        break;
                    }
                    case PULL_ALL: {
                        handler.onPullAll();
                        break;
                    }
                    default: {
                        throw new BoltIOException((Status)Status.Request.Invalid, "Message 0x" + Integer.toHexString(signature) + " is not supported.");
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new BoltIOException((Status)Status.Request.Invalid, "0x" + Integer.toHexString(signature) + " is not a valid message signature.");
            }
        }
        catch (PackStream.PackStreamException e) {
            throw new BoltIOException((Status)Status.Request.InvalidFormat, "Unable to read message type. Error was: " + e.getMessage(), e);
        }
    }
}

