/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.v1.messaging;

import java.io.IOException;
import java.util.Map;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.v1.messaging.BoltRequestMessageHandler;
import org.neo4j.bolt.v1.messaging.BoltResponseMessageHandler;
import org.neo4j.bolt.v1.messaging.MessageProcessingHandler;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.Neo4jError;
import org.neo4j.bolt.v1.runtime.spi.BoltResult;
import org.neo4j.cypher.result.QueryResult;
import org.neo4j.logging.Log;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.MapValue;

public class BoltMessageRouter
implements BoltRequestMessageHandler<RuntimeException> {
    private final BoltMessageLogger messageLogger;
    private final MessageProcessingHandler initHandler;
    private final MessageProcessingHandler runHandler;
    private final MessageProcessingHandler resultHandler;
    private final MessageProcessingHandler defaultHandler;
    private BoltWorker worker;

    public BoltMessageRouter(Log internalLog, BoltMessageLogger messageLogger, BoltWorker worker, BoltResponseMessageHandler<IOException> output, Runnable onEachCompletedRequest) {
        this.messageLogger = messageLogger;
        this.initHandler = new InitHandler(output, onEachCompletedRequest, worker, internalLog);
        this.runHandler = new RunHandler(output, onEachCompletedRequest, worker, internalLog);
        this.resultHandler = new ResultHandler(output, onEachCompletedRequest, worker, internalLog);
        this.defaultHandler = new MessageProcessingHandler(output, onEachCompletedRequest, worker, internalLog);
        this.worker = worker;
    }

    @Override
    public void onInit(String userAgent, Map<String, Object> authToken) throws RuntimeException {
        this.messageLogger.logInit(userAgent);
        this.worker.enqueue(session -> session.init(userAgent, authToken, this.initHandler));
    }

    @Override
    public void onAckFailure() throws RuntimeException {
        this.messageLogger.logAckFailure();
        this.worker.enqueue(session -> session.ackFailure(this.defaultHandler));
    }

    @Override
    public void onReset() throws RuntimeException {
        this.messageLogger.clientEvent("INTERRUPT");
        this.messageLogger.logReset();
        this.worker.interrupt();
        this.worker.enqueue(session -> session.reset(this.defaultHandler));
    }

    @Override
    public void onRun(String statement, MapValue params) {
        this.messageLogger.logRun();
        this.worker.enqueue(session -> session.run(statement, params, this.runHandler));
    }

    @Override
    public void onExternalError(Neo4jError error) {
        this.messageLogger.clientEvent("ERROR", error::message);
        this.worker.enqueue(session -> session.externalError(error, this.defaultHandler));
    }

    @Override
    public void onDiscardAll() {
        this.messageLogger.logDiscardAll();
        this.worker.enqueue(session -> session.discardAll(this.resultHandler));
    }

    @Override
    public void onPullAll() {
        this.messageLogger.logPullAll();
        this.worker.enqueue(session -> session.pullAll(this.resultHandler));
    }

    private static class ResultHandler
    extends MessageProcessingHandler {
        ResultHandler(BoltResponseMessageHandler<IOException> handler, Runnable onCompleted, BoltWorker worker, Log log) {
            super(handler, onCompleted, worker, log);
        }

        @Override
        public void onRecords(BoltResult result, final boolean pull) throws Exception {
            result.accept(new BoltResult.Visitor(){

                @Override
                public void visit(QueryResult.Record record) throws Exception {
                    if (pull) {
                        handler.onRecord(record);
                    }
                }

                @Override
                public void addMetadata(String key, AnyValue value) {
                    metadata.put(key, value);
                }
            });
        }
    }

    private static class RunHandler
    extends MessageProcessingHandler {
        RunHandler(BoltResponseMessageHandler<IOException> handler, Runnable onCompleted, BoltWorker worker, Log log) {
            super(handler, onCompleted, worker, log);
        }
    }

    private static class InitHandler
    extends MessageProcessingHandler {
        InitHandler(BoltResponseMessageHandler<IOException> handler, Runnable onCompleted, BoltWorker worker, Log log) {
            super(handler, onCompleted, worker, log);
        }
    }
}

