/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.transport.BoltHandshakeProtocolHandler;
import org.neo4j.bolt.transport.BoltMessagingProtocolHandler;
import org.neo4j.bolt.transport.HandshakeOutcome;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class SocketTransportHandler
extends ChannelInboundHandlerAdapter {
    private final BoltHandshakeProtocolHandler handshake;
    private final Log log;
    private final BoltMessageLogging boltLogging;
    private BoltMessagingProtocolHandler protocol;

    public SocketTransportHandler(BoltHandshakeProtocolHandler handshake, LogProvider logging, BoltMessageLogging boltLogging) {
        this.handshake = handshake;
        this.log = logging.getLog(((Object)((Object)this)).getClass());
        this.boltLogging = boltLogging;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buffer = (ByteBuf)msg;
            if (this.protocol == null) {
                BoltMessageLogger boltLogger = this.boltLogging.newLogger(ctx.channel());
                boltLogger.clientEvent("OPEN");
                this.performHandshake(BoltChannel.open(ctx, boltLogger), buffer);
            } else {
                this.protocol.handle(ctx, buffer);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.close(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.close(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.log.error("Fatal error occurred when handling a client connection: " + ctx.channel(), cause);
        this.close(ctx);
    }

    private void close(ChannelHandlerContext ctx) {
        if (this.protocol != null) {
            this.protocol.close();
            this.protocol = null;
        } else {
            ctx.close();
        }
    }

    private void performHandshake(BoltChannel boltChannel, ByteBuf buffer) throws Exception {
        ChannelHandlerContext ctx = boltChannel.channelHandlerContext();
        HandshakeOutcome outcome = this.handshake.perform(boltChannel, buffer);
        switch (outcome) {
            case PROTOCOL_CHOSEN: {
                this.protocol = this.handshake.chosenProtocol();
                ctx.writeAndFlush((Object)ctx.alloc().buffer(4).writeInt(this.protocol.version()));
                if (buffer.readableBytes() > 0) {
                    this.channelRead(ctx, buffer);
                } else {
                    buffer.release();
                }
                return;
            }
            case NO_APPLICABLE_PROTOCOL: {
                buffer.release();
                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{0, 0, 0, 0})).sync().channel().close();
                return;
            }
            case INSECURE_HANDSHAKE: 
            case INVALID_HANDSHAKE: {
                buffer.release();
                ctx.close();
                return;
            }
            case PARTIAL_HANDSHAKE: {
                return;
            }
        }
        throw new IllegalStateException("Unknown handshake outcome: " + (Object)((Object)outcome));
    }
}

