/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.logging;

import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.codehaus.jackson.map.ObjectMapper;
import org.neo4j.bolt.logging.BoltMessageLog;
import org.neo4j.bolt.logging.BoltMessageLogger;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.values.AnyValue;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.utils.PrettyPrinter;
import org.neo4j.values.virtual.MapValue;

class BoltMessageLoggerImpl
implements BoltMessageLogger {
    private static final ObjectMapper jsonObjectMapper = new ObjectMapper();
    private static final Supplier<String> PLACEHOLDER_DETAIL_SUPPLIER = () -> "-";
    private final BoltMessageLog messageLog;
    private final String remoteAddress;
    private Channel channel;
    private static final String BOLT_X_CORRELATION_ID_HEADER = "BoltCorrelationId";
    public static final AttributeKey<String> CORRELATION_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"BoltCorrelationId");

    BoltMessageLoggerImpl(BoltMessageLog messageLog, Channel channel) {
        this.messageLog = messageLog;
        this.channel = channel;
        this.remoteAddress = BoltMessageLoggerImpl.remoteAddress(channel);
    }

    @Override
    public void clientEvent(String eventName) {
        this.clientEvent(eventName, PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void clientEvent(String eventName, Supplier<String> detailsSupplier) {
        this.infoLogger().accept(String.format("C %s", eventName), detailsSupplier.get());
    }

    @Override
    public void clientError(String eventName, String errorMessage, Supplier<String> detailsSupplier) {
        this.errorLoggerWithArgs(errorMessage).accept(String.format("C %s", eventName), detailsSupplier.get());
    }

    @Override
    public void serverEvent(String eventName) {
        this.serverEvent(eventName, PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void serverEvent(String eventName, Supplier<String> detailsSupplier) {
        this.infoLogger().accept(String.format("S %s", eventName), detailsSupplier.get());
    }

    @Override
    public void serverError(String eventName, String errorMessage) {
        this.errorLogger(errorMessage).accept(String.format("S %s", eventName));
    }

    @Override
    public void serverError(String eventName, Status status) {
        this.serverError(eventName, status.code().serialize());
    }

    @Override
    public void logInit(String userAgent) {
        this.clientEvent("INIT", () -> userAgent);
    }

    @Override
    public void logRun() {
        this.clientEvent("RUN", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void logPullAll() {
        this.clientEvent("PULL_ALL", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void logDiscardAll() {
        this.clientEvent("DISCARD_ALL", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void logAckFailure() {
        this.clientEvent("ACK_FAILURE", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void logReset() {
        this.clientEvent("RESET", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    @Override
    public void logSuccess(Supplier<MapValue> metadataSupplier) {
        this.serverEvent("SUCCESS", () -> BoltMessageLoggerImpl.formatAnyValue((AnyValue)metadataSupplier.get()));
    }

    @Override
    public void logFailure(Status status) {
        this.serverEvent("FAILURE", () -> status.code().serialize());
    }

    @Override
    public void logIgnored() {
        this.serverEvent("IGNORED", PLACEHOLDER_DETAIL_SUPPLIER);
    }

    private Consumer<String> errorLogger(String errorMessage) {
        return formatMessageWithEventName -> this.messageLog.error(this.remoteAddress, this.getCorrelationId(), (String)formatMessageWithEventName, errorMessage);
    }

    private String randomCorrelationIdGenerator() {
        return UUID.randomUUID().toString();
    }

    private BiConsumer<String, String> infoLogger() {
        return (formatMessageWithEventName, details) -> this.messageLog.info(this.remoteAddress, this.getCorrelationId(), String.format("%s %s", formatMessageWithEventName, details));
    }

    private String getCorrelationId() {
        if (!this.channel.hasAttr(CORRELATION_ATTRIBUTE_KEY)) {
            this.channel.attr(CORRELATION_ATTRIBUTE_KEY).set((Object)this.randomCorrelationIdGenerator());
        }
        return (String)this.channel.attr(CORRELATION_ATTRIBUTE_KEY).get();
    }

    private BiConsumer<String, String> errorLoggerWithArgs(String errorMessage) {
        return (formatMessageWithEventName, details) -> this.errorLogger(errorMessage).accept(String.format("%s %s", formatMessageWithEventName, details));
    }

    private static String remoteAddress(Channel channel) {
        try {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.remoteAddress();
            InetAddress address = remoteAddress.getAddress();
            String hostAddress = address.getHostAddress();
            int port = remoteAddress.getPort();
            return String.format("%s:%s", hostAddress, port);
        }
        catch (ClassCastException e) {
            SocketAddress remoteAddress = channel.remoteAddress();
            return remoteAddress.toString();
        }
    }

    private static String json(Object arg) {
        try {
            return jsonObjectMapper.writeValueAsString(arg);
        }
        catch (IOException e) {
            return "?";
        }
    }

    private static String formatAnyValue(AnyValue mapValue) {
        PrettyPrinter printer = new PrettyPrinter();
        mapValue.writeTo((AnyValueWriter)printer);
        return printer.value();
    }
}

