/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt;

import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.BoltChannel;
import org.neo4j.bolt.logging.BoltMessageLogging;
import org.neo4j.bolt.security.auth.Authentication;
import org.neo4j.bolt.security.auth.BasicAuthentication;
import org.neo4j.bolt.transport.BoltMessagingProtocolHandler;
import org.neo4j.bolt.transport.Netty4LoggerFactory;
import org.neo4j.bolt.transport.NettyServer;
import org.neo4j.bolt.transport.SocketTransport;
import org.neo4j.bolt.v1.runtime.BoltChannelAutoReadLimiter;
import org.neo4j.bolt.v1.runtime.BoltFactory;
import org.neo4j.bolt.v1.runtime.BoltFactoryImpl;
import org.neo4j.bolt.v1.runtime.BoltWorker;
import org.neo4j.bolt.v1.runtime.MonitoredWorkerFactory;
import org.neo4j.bolt.v1.runtime.WorkerFactory;
import org.neo4j.bolt.v1.runtime.concurrent.ThreadedWorkerFactory;
import org.neo4j.bolt.v1.transport.BoltMessagingProtocolV1Handler;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.LoadableConfig;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.bolt.BoltConnectionTracker;
import org.neo4j.kernel.api.security.AuthManager;
import org.neo4j.kernel.api.security.UserManagerSupplier;
import org.neo4j.kernel.configuration.BoltConnector;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.configuration.ConnectorPortRegister;
import org.neo4j.kernel.configuration.ssl.SslPolicyLoader;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.core.ThreadToStatementContextBridge;
import org.neo4j.kernel.impl.logging.LogService;
import org.neo4j.kernel.impl.spi.KernelContext;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.udc.UsageData;

public class BoltKernelExtension
extends KernelExtensionFactory<Dependencies> {
    public BoltKernelExtension() {
        super("bolt-server");
    }

    public Lifecycle newInstance(KernelContext context, Dependencies dependencies) throws Throwable {
        Config config = dependencies.config();
        GraphDatabaseService gdb = dependencies.db();
        GraphDatabaseAPI api = (GraphDatabaseAPI)gdb;
        LogService logService = dependencies.logService();
        Clock clock = dependencies.clock();
        SslPolicyLoader sslPolicyFactory = dependencies.sslPolicyFactory();
        Log log = logService.getInternalLog(WorkerFactory.class);
        LifeSupport life = new LifeSupport();
        JobScheduler scheduler = dependencies.scheduler();
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Netty4LoggerFactory(logService.getInternalLogProvider()));
        BoltMessageLogging boltLogging = BoltMessageLogging.create(dependencies.fileSystem(), scheduler, config, log);
        Authentication authentication = this.authentication(dependencies.authManager(), dependencies.userManagerSupplier());
        BoltFactory boltFactory = (BoltFactory)life.add((Lifecycle)new BoltFactoryImpl(api, dependencies.usageData(), logService, dependencies.txBridge(), authentication, dependencies.sessionTracker(), config));
        WorkerFactory workerFactory = this.createWorkerFactory(boltFactory, scheduler, dependencies, logService, clock);
        ConnectorPortRegister connectionRegister = dependencies.connectionRegister();
        Map<BoltConnector, NettyServer.ProtocolInitializer> connectors = config.enabledBoltConnectors().stream().collect(Collectors.toMap(Function.identity(), connConfig -> {
            SslContext sslCtx;
            boolean requireEncryption;
            ListenSocketAddress listenAddress = (ListenSocketAddress)config.get(connConfig.listen_address);
            BoltConnector.EncryptionLevel encryptionLevel = (BoltConnector.EncryptionLevel)config.get(connConfig.encryption_level);
            switch (encryptionLevel) {
                case REQUIRED: {
                    requireEncryption = true;
                    sslCtx = this.createSslContext(sslPolicyFactory, config);
                    break;
                }
                case OPTIONAL: {
                    requireEncryption = false;
                    sslCtx = this.createSslContext(sslPolicyFactory, config);
                    break;
                }
                case DISABLED: {
                    requireEncryption = false;
                    sslCtx = null;
                    break;
                }
                default: {
                    log.warn(String.format("Unhandled encryption level %s - assuming DISABLED.", encryptionLevel.name()));
                    requireEncryption = false;
                    sslCtx = null;
                }
            }
            Map<Long, Function<BoltChannel, BoltMessagingProtocolHandler>> protocolHandlers = this.getProtocolHandlers(logService, workerFactory);
            return new SocketTransport(listenAddress, sslCtx, requireEncryption, logService.getInternalLogProvider(), boltLogging, protocolHandlers);
        }));
        if (connectors.size() > 0 && !((Boolean)config.get(GraphDatabaseSettings.disconnected)).booleanValue()) {
            life.add((Lifecycle)new NettyServer(scheduler.threadFactory(JobScheduler.Groups.boltNetworkIO), connectors, connectionRegister));
            log.info("Bolt Server extension loaded.");
            for (NettyServer.ProtocolInitializer connector : connectors.values()) {
                logService.getUserLog(WorkerFactory.class).info("Bolt enabled on %s.", new Object[]{connector.address()});
            }
        }
        return life;
    }

    protected WorkerFactory createWorkerFactory(BoltFactory boltFactory, JobScheduler scheduler, Dependencies dependencies, LogService logService, Clock clock) {
        ThreadedWorkerFactory threadedWorkerFactory = new ThreadedWorkerFactory(boltFactory, scheduler, logService, clock);
        return new MonitoredWorkerFactory(dependencies.monitors(), threadedWorkerFactory, clock);
    }

    private SslContext createSslContext(SslPolicyLoader sslPolicyFactory, Config config) {
        try {
            String policyName = (String)config.get(Settings.ssl_policy);
            if (policyName == null) {
                throw new IllegalArgumentException("No SSL policy has been configured for bolt");
            }
            return sslPolicyFactory.getPolicy(policyName).nettyServerContext();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize SSL encryption support, which is required to start this connector. Error was: " + e.getMessage(), e);
        }
    }

    private Map<Long, Function<BoltChannel, BoltMessagingProtocolHandler>> getProtocolHandlers(LogService logging, WorkerFactory workerFactory) {
        HashMap<Long, Function<BoltChannel, BoltMessagingProtocolHandler>> protocolHandlers = new HashMap<Long, Function<BoltChannel, BoltMessagingProtocolHandler>>();
        protocolHandlers.put(1L, boltChannel -> this.createV1Handler((BoltChannel)boltChannel, logging, workerFactory));
        return protocolHandlers;
    }

    private BoltMessagingProtocolHandler createV1Handler(BoltChannel boltChannel, LogService logging, WorkerFactory workerFactory) {
        BoltChannelAutoReadLimiter limiter = new BoltChannelAutoReadLimiter(boltChannel.rawChannel(), logging.getInternalLog(BoltChannelAutoReadLimiter.class));
        BoltWorker worker = workerFactory.newWorker(boltChannel, limiter);
        return new BoltMessagingProtocolV1Handler(boltChannel, worker, logging);
    }

    private Authentication authentication(AuthManager authManager, UserManagerSupplier userManagerSupplier) {
        return new BasicAuthentication(authManager, userManagerSupplier);
    }

    public static interface Dependencies {
        public LogService logService();

        public Config config();

        public GraphDatabaseService db();

        public JobScheduler scheduler();

        public UsageData usageData();

        public Monitors monitors();

        public ThreadToStatementContextBridge txBridge();

        public BoltConnectionTracker sessionTracker();

        public ConnectorPortRegister connectionRegister();

        public Clock clock();

        public AuthManager authManager();

        public UserManagerSupplier userManagerSupplier();

        public SslPolicyLoader sslPolicyFactory();

        public FileSystemAbstraction fileSystem();
    }

    public static class Settings
    implements LoadableConfig {
        @Description(value="Specify the SSL policy to use")
        public static Setting<String> ssl_policy = org.neo4j.kernel.configuration.Settings.setting((String)"bolt.ssl_policy", (Function)org.neo4j.kernel.configuration.Settings.STRING, (String)"legacy");
    }
}

