/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.connection.pooled;

import java.net.URI;
import java.time.Clock;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.neo4j.bolt.connection.AuthInfo;
import org.neo4j.bolt.connection.AuthToken;
import org.neo4j.bolt.connection.BasicResponseHandler;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.bolt.connection.BoltConnection;
import org.neo4j.bolt.connection.BoltConnectionParameters;
import org.neo4j.bolt.connection.BoltConnectionProvider;
import org.neo4j.bolt.connection.BoltConnectionSource;
import org.neo4j.bolt.connection.BoltConnectionState;
import org.neo4j.bolt.connection.BoltProtocolVersion;
import org.neo4j.bolt.connection.BoltServerAddress;
import org.neo4j.bolt.connection.ListenerEvent;
import org.neo4j.bolt.connection.LoggingProvider;
import org.neo4j.bolt.connection.MetricsListener;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.bolt.connection.exception.BoltFailureException;
import org.neo4j.bolt.connection.exception.BoltTransientException;
import org.neo4j.bolt.connection.exception.MinVersionAcquisitionException;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.bolt.connection.pooled.AuthTokenManager;
import org.neo4j.bolt.connection.pooled.SecurityPlanSupplier;
import org.neo4j.bolt.connection.pooled.impl.PooledBoltConnection;
import org.neo4j.bolt.connection.pooled.impl.util.FutureUtil;

public class PooledBoltConnectionSource
implements BoltConnectionSource<BoltConnectionParameters> {
    private final System.Logger log;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final BoltConnectionProvider boltConnectionProvider;
    private final List<ConnectionEntry> pooledConnectionEntries;
    private final Queue<CompletableFuture<PooledBoltConnection>> pendingAcquisitions;
    private final int maxSize;
    private final long acquisitionTimeout;
    private final long maxLifetime;
    private final long idleBeforeTest;
    private final Clock clock;
    private final MetricsListener metricsListener;
    private final URI uri;
    private final BoltServerAddress address;
    private final String routingContextAddress;
    private final BoltAgent boltAgent;
    private final String userAgent;
    private final int connectTimeoutMillis;
    private final String poolId;
    private final AuthTokenManager authTokenManager;
    private final SecurityPlanSupplier securityPlanSupplier;
    private final NotificationConfig notificationConfig;
    private CompletionStage<Void> closeStage;
    private long minAuthTimestamp;

    public PooledBoltConnectionSource(LoggingProvider loggingProvider, Clock clock, URI uri, BoltConnectionProvider boltConnectionProvider, AuthTokenManager authTokenManager, SecurityPlanSupplier securityPlanSupplier, int maxSize, long acquisitionTimeout, long maxLifetime, long idleBeforeTest, MetricsListener metricsListener, String routingContextAddress, BoltAgent boltAgent, String userAgent, int connectTimeoutMillis, NotificationConfig notificationConfig) {
        this.boltConnectionProvider = Objects.requireNonNull(boltConnectionProvider);
        this.pooledConnectionEntries = new ArrayList<ConnectionEntry>();
        this.pendingAcquisitions = new ArrayDeque<CompletableFuture<PooledBoltConnection>>(100);
        this.maxSize = maxSize;
        this.acquisitionTimeout = acquisitionTimeout;
        this.maxLifetime = maxLifetime;
        this.idleBeforeTest = idleBeforeTest;
        this.clock = Objects.requireNonNull(clock);
        this.log = loggingProvider.getLog(this.getClass());
        this.metricsListener = Objects.requireNonNull(metricsListener);
        this.uri = Objects.requireNonNull(uri);
        this.address = switch (uri.getScheme()) {
            case "bolt", "bolt+s", "bolt+ssc", "neo4j", "neo4j+s", "neo4j+ssc" -> new BoltServerAddress(uri);
            default -> new BoltServerAddress(uri.getHost(), 0);
        };
        this.routingContextAddress = routingContextAddress;
        this.boltAgent = Objects.requireNonNull(boltAgent);
        this.userAgent = Objects.requireNonNull(userAgent);
        this.connectTimeoutMillis = connectTimeoutMillis;
        this.authTokenManager = Objects.requireNonNull(authTokenManager);
        this.securityPlanSupplier = Objects.requireNonNull(securityPlanSupplier);
        this.notificationConfig = Objects.requireNonNull(notificationConfig);
        this.poolId = this.poolId(this.address);
        metricsListener.registerPoolMetrics(this.poolId, this.address, () -> {
            PooledBoltConnectionSource pooledBoltConnectionSource = this;
            synchronized (pooledBoltConnectionSource) {
                return (int)this.pooledConnectionEntries.stream().filter(entry -> !entry.available).count();
            }
        }, () -> {
            PooledBoltConnectionSource pooledBoltConnectionSource = this;
            synchronized (pooledBoltConnectionSource) {
                return (int)this.pooledConnectionEntries.stream().filter(entry -> entry.available).count();
            }
        });
    }

    public CompletionStage<BoltConnection> getConnection() {
        return this.getConnection(BoltConnectionParameters.defaultParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<BoltConnection> getConnection(BoltConnectionParameters parameters) {
        boolean overrideAuthToken;
        CompletionStage<AuthToken> authTokenSupplier;
        PooledBoltConnectionSource pooledBoltConnectionSource = this;
        synchronized (pooledBoltConnectionSource) {
            if (this.closeStage != null) {
                return CompletableFuture.failedFuture(new IllegalStateException("Connection source is closed."));
            }
        }
        CompletableFuture acquisitionFuture = new CompletableFuture();
        if (parameters.authToken() != null) {
            authTokenSupplier = CompletableFuture.completedStage(parameters.authToken());
            overrideAuthToken = true;
        } else {
            authTokenSupplier = this.authTokenManager.getToken();
            overrideAuthToken = false;
        }
        authTokenSupplier.whenComplete((authToken, authThrowable) -> {
            if (authThrowable != null) {
                acquisitionFuture.completeExceptionally((Throwable)authThrowable);
                return;
            }
            ListenerEvent beforeAcquiringOrCreatingEvent = this.metricsListener.createListenerEvent();
            this.metricsListener.beforeAcquiringOrCreating(this.poolId, beforeAcquiringOrCreatingEvent);
            acquisitionFuture.whenComplete((connection, throwable) -> {
                if ((throwable = FutureUtil.completionExceptionCause(throwable)) != null) {
                    if (throwable instanceof TimeoutException) {
                        this.metricsListener.afterTimedOutToAcquireOrCreate(this.poolId);
                    }
                } else {
                    this.metricsListener.afterAcquiredOrCreated(this.poolId, beforeAcquiringOrCreatingEvent);
                }
                this.metricsListener.afterAcquiringOrCreating(this.poolId);
            });
            this.connect(acquisitionFuture, (AuthToken)authToken, overrideAuthToken, parameters.minVersion(), this.notificationConfig);
        });
        return acquisitionFuture.thenApply(Function.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(CompletableFuture<PooledBoltConnection> acquisitionFuture, AuthToken authToken, boolean overrideAuthToken, BoltProtocolVersion minVersion, NotificationConfig notificationConfig) {
        ConnectionEntryWithMetadata connectionEntryWithMetadata = null;
        BoltTransientException pendingAcquisitionsFull = null;
        AtomicBoolean empty = new AtomicBoolean();
        PooledBoltConnectionSource pooledBoltConnectionSource = this;
        synchronized (pooledBoltConnectionSource) {
            try {
                empty.set(this.pooledConnectionEntries.isEmpty());
                try {
                    connectionEntryWithMetadata = this.acquireExistingEntry(authToken, minVersion);
                }
                catch (MinVersionAcquisitionException e) {
                    acquisitionFuture.completeExceptionally(e);
                    return;
                }
                if (connectionEntryWithMetadata == null) {
                    if (this.pooledConnectionEntries.size() < this.maxSize) {
                        ConnectionEntry acquiredEntry = new ConnectionEntry();
                        this.pooledConnectionEntries.add(acquiredEntry);
                        connectionEntryWithMetadata = new ConnectionEntryWithMetadata(acquiredEntry, false);
                    } else if (this.pendingAcquisitions.size() < 100 && !acquisitionFuture.isDone()) {
                        if (this.acquisitionTimeout > 0L) {
                            this.pendingAcquisitions.add(acquisitionFuture);
                        }
                        this.executorService.schedule(() -> {
                            PooledBoltConnectionSource pooledBoltConnectionSource = this;
                            synchronized (pooledBoltConnectionSource) {
                                this.pendingAcquisitions.remove(acquisitionFuture);
                            }
                            try {
                                acquisitionFuture.completeExceptionally(new TimeoutException("Unable to acquire connection from the pool within configured maximum time of " + this.acquisitionTimeout + "ms"));
                            }
                            catch (Throwable throwable) {
                                this.log.log(System.Logger.Level.WARNING, "Unexpected error occurred.", throwable);
                            }
                        }, this.acquisitionTimeout, TimeUnit.MILLISECONDS);
                    } else {
                        pendingAcquisitionsFull = new BoltTransientException("Connection pool pending acquisition queue is full.");
                    }
                }
            }
            catch (Throwable throwable2) {
                if (connectionEntryWithMetadata != null) {
                    if (connectionEntryWithMetadata.connectionEntry.connection != null) {
                        connectionEntryWithMetadata.connectionEntry.available = true;
                    } else {
                        this.pooledConnectionEntries.remove(connectionEntryWithMetadata.connectionEntry);
                    }
                }
                this.pendingAcquisitions.remove(acquisitionFuture);
                acquisitionFuture.completeExceptionally(throwable2);
            }
        }
        if (pendingAcquisitionsFull != null) {
            acquisitionFuture.completeExceptionally((Throwable)pendingAcquisitionsFull);
        } else if (connectionEntryWithMetadata != null) {
            if (connectionEntryWithMetadata.connectionEntry.connection != null) {
                ConnectionEntryWithMetadata entryWithMetadata = connectionEntryWithMetadata;
                entry = entryWithMetadata.connectionEntry;
                this.livenessCheckStage(entry).whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        this.purge(entry);
                        this.connect(acquisitionFuture, authToken, overrideAuthToken, minVersion, notificationConfig);
                    } else {
                        ListenerEvent inUseEvent = this.metricsListener.createListenerEvent();
                        PooledBoltConnection pooledConnection = new PooledBoltConnection(entry.connection, this, () -> {
                            this.release(entry);
                            this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
                        }, () -> {
                            this.purge(entry);
                            this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
                        });
                        this.reauthStage(entryWithMetadata, authToken).whenComplete((ignored2, throwable2) -> {
                            if (!acquisitionFuture.complete(pooledConnection)) {
                                CompletableFuture<PooledBoltConnection> pendingAcquisition;
                                PooledBoltConnectionSource pooledBoltConnectionSource = this;
                                synchronized (pooledBoltConnectionSource) {
                                    pendingAcquisition = this.pendingAcquisitions.poll();
                                    if (pendingAcquisition == null) {
                                        entry.available = true;
                                    }
                                }
                                if (pendingAcquisition != null && pendingAcquisition.complete(pooledConnection)) {
                                    this.metricsListener.afterConnectionCreated(this.poolId, inUseEvent);
                                }
                            } else {
                                this.metricsListener.afterConnectionCreated(this.poolId, inUseEvent);
                            }
                        });
                    }
                });
            } else {
                ListenerEvent createEvent = this.metricsListener.createListenerEvent();
                this.metricsListener.beforeCreating(this.poolId, createEvent);
                entry = connectionEntryWithMetadata.connectionEntry;
                CompletionStage authStage = this.securityPlanSupplier.getPlan().thenCompose(securityPlan -> {
                    if (overrideAuthToken || empty.get()) {
                        return CompletableFuture.completedStage(new SecurityPlanAndAuthToken((SecurityPlan)securityPlan, authToken));
                    }
                    return this.authTokenManager.getToken().thenApply(token -> new SecurityPlanAndAuthToken((SecurityPlan)securityPlan, (AuthToken)token));
                });
                authStage.thenCompose(auth -> this.boltConnectionProvider.connect(this.uri, this.routingContextAddress, this.boltAgent, this.userAgent, this.connectTimeoutMillis, auth.securityPlan(), auth.authToken(), minVersion, notificationConfig)).whenComplete((boltConnection, throwable) -> {
                    Throwable error = FutureUtil.completionExceptionCause(throwable);
                    if (error != null) {
                        PooledBoltConnectionSource pooledBoltConnectionSource = this;
                        synchronized (pooledBoltConnectionSource) {
                            this.pooledConnectionEntries.remove(entry);
                        }
                        this.metricsListener.afterFailedToCreate(this.poolId);
                        if (error instanceof BoltFailureException) {
                            BoltFailureException boltFailureException = (BoltFailureException)error;
                            SecurityPlanAndAuthToken usedAuth = authStage.toCompletableFuture().getNow(null);
                            if (usedAuth != null) {
                                error = this.authTokenManager.handleBoltFailureException(usedAuth.authToken(), boltFailureException);
                            }
                        }
                        acquisitionFuture.completeExceptionally(error);
                    } else {
                        PooledBoltConnectionSource boltFailureException = this;
                        synchronized (boltFailureException) {
                            entry.connection = boltConnection;
                            entry.createdTimestamp = this.clock.millis();
                        }
                        this.metricsListener.afterCreated(this.poolId, createEvent);
                        ListenerEvent inUseEvent = this.metricsListener.createListenerEvent();
                        PooledBoltConnection pooledConnection = new PooledBoltConnection((BoltConnection)boltConnection, this, () -> {
                            this.release(entry);
                            this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
                        }, () -> {
                            this.purge(entry);
                            this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
                        });
                        if (!acquisitionFuture.complete(pooledConnection)) {
                            CompletableFuture<PooledBoltConnection> pendingAcquisition;
                            PooledBoltConnectionSource pooledBoltConnectionSource = this;
                            synchronized (pooledBoltConnectionSource) {
                                pendingAcquisition = this.pendingAcquisitions.poll();
                                if (pendingAcquisition == null) {
                                    entry.available = true;
                                }
                            }
                            if (pendingAcquisition != null && pendingAcquisition.complete(pooledConnection)) {
                                this.metricsListener.afterConnectionCreated(this.poolId, inUseEvent);
                            }
                        } else {
                            this.metricsListener.afterConnectionCreated(this.poolId, inUseEvent);
                        }
                    }
                });
            }
        }
    }

    private synchronized ConnectionEntryWithMetadata acquireExistingEntry(AuthToken authToken, BoltProtocolVersion minVersion) {
        ConnectionEntryWithMetadata connectionEntryWithMetadata = null;
        Iterator<ConnectionEntry> iterator = this.pooledConnectionEntries.iterator();
        while (iterator.hasNext()) {
            boolean reauthNeeded;
            long currentTime;
            ConnectionEntry connectionEntry = iterator.next();
            if (!connectionEntry.available) continue;
            BoltConnection connection = connectionEntry.connection;
            if (connection.state() != BoltConnectionState.OPEN) {
                connection.close();
                iterator.remove();
                continue;
            }
            if (minVersion != null && minVersion.compareTo(connection.protocolVersion()) > 0) {
                throw new MinVersionAcquisitionException("lower version", connection.protocolVersion());
            }
            if (this.maxLifetime > 0L && (currentTime = this.clock.millis()) - connectionEntry.createdTimestamp > this.maxLifetime) {
                connection.close();
                iterator.remove();
                this.metricsListener.afterClosed(this.poolId);
                continue;
            }
            AuthInfo authInfo = connection.authInfo().toCompletableFuture().getNow(null);
            boolean expiredByError = this.minAuthTimestamp > 0L && authInfo.authAckMillis() <= this.minAuthTimestamp;
            boolean authMatches = authToken.equals((Object)authInfo.authToken());
            boolean bl = reauthNeeded = expiredByError || !authMatches;
            if (reauthNeeded && new BoltProtocolVersion(5, 1).compareTo(connectionEntry.connection.protocolVersion()) > 0) {
                this.log.log(System.Logger.Level.DEBUG, "reauth is not supported, the connection is voided");
                iterator.remove();
                connectionEntry.connection.close().whenComplete((ignored, throwable) -> {
                    if (throwable != null) {
                        this.log.log(System.Logger.Level.WARNING, "Connection close has failed with %s.", throwable.getClass().getCanonicalName());
                    }
                });
                continue;
            }
            this.log.log(System.Logger.Level.DEBUG, "Connection acquired from the pool. " + String.valueOf(this.address));
            connectionEntry.available = false;
            connectionEntryWithMetadata = new ConnectionEntryWithMetadata(connectionEntry, reauthNeeded);
            break;
        }
        return connectionEntryWithMetadata;
    }

    private CompletionStage<Void> reauthStage(ConnectionEntryWithMetadata connectionEntryWithMetadata, AuthToken authToken) {
        CompletionStage<Object> stage = connectionEntryWithMetadata.reauthNeeded ? connectionEntryWithMetadata.connectionEntry.connection.write(List.of(Messages.logoff(), Messages.logon((AuthToken)authToken))).handle((ignored, throwable) -> {
            if (throwable != null) {
                connectionEntryWithMetadata.connectionEntry.connection.close();
                PooledBoltConnectionSource pooledBoltConnectionSource = this;
                synchronized (pooledBoltConnectionSource) {
                    this.pooledConnectionEntries.remove(connectionEntryWithMetadata.connectionEntry);
                }
            }
            return null;
        }) : CompletableFuture.completedStage(null);
        return stage;
    }

    private CompletionStage<Void> livenessCheckStage(ConnectionEntry entry) {
        CompletionStage<Object> stage;
        if (this.idleBeforeTest >= 0L && entry.lastUsedTimestamp + this.idleBeforeTest < this.clock.millis()) {
            BasicResponseHandler resetHandler = new BasicResponseHandler();
            stage = entry.connection.writeAndFlush((ResponseHandler)resetHandler, (Message)Messages.reset()).thenCompose(ignored -> resetHandler.summaries()).thenApply(ignored -> null);
        } else {
            stage = CompletableFuture.completedStage(null);
        }
        return stage;
    }

    public CompletionStage<Void> verifyConnectivity() {
        return this.getConnection().thenCompose(BoltConnection::close);
    }

    public CompletionStage<Boolean> supportsMultiDb() {
        return this.getConnection().thenCompose(boltConnection -> {
            boolean supports = boltConnection.protocolVersion().compareTo(new BoltProtocolVersion(4, 0)) >= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.getConnection().thenCompose(boltConnection -> {
            boolean supports = new BoltProtocolVersion(5, 1).compareTo(boltConnection.protocolVersion()) <= 0;
            return boltConnection.close().thenApply(ignored -> supports);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<Void> close() {
        CompletionStage<Void> closeStage;
        PooledBoltConnectionSource pooledBoltConnectionSource = this;
        synchronized (pooledBoltConnectionSource) {
            if (this.closeStage == null) {
                this.closeStage = CompletableFuture.completedStage(null);
                Iterator<ConnectionEntry> iterator = this.pooledConnectionEntries.iterator();
                while (iterator.hasNext()) {
                    ConnectionEntry entry = iterator.next();
                    if (entry.connection != null && entry.connection.state() == BoltConnectionState.OPEN) {
                        this.closeStage = this.closeStage.thenCompose(ignored -> entry.connection.close().exceptionally(throwable -> null));
                    }
                    iterator.remove();
                }
                this.metricsListener.removePoolMetrics(this.poolId);
                this.closeStage = this.closeStage.thenCompose(ignored -> this.boltConnectionProvider.close()).exceptionally(throwable -> null).whenComplete((ignored, throwable) -> this.executorService.shutdown());
            }
            closeStage = this.closeStage;
        }
        return closeStage;
    }

    synchronized int size() {
        return this.pooledConnectionEntries.size();
    }

    synchronized int inUse() {
        return this.pooledConnectionEntries.stream().filter(entry -> !entry.available).toList().size();
    }

    private String poolId(BoltServerAddress serverAddress) {
        return serverAddress.port() == 0 ? String.format("%s-%d", serverAddress.host(), this.hashCode()) : String.format("%s:%d-%d", serverAddress.host(), serverAddress.port(), this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(ConnectionEntry entry) {
        ListenerEvent inUseEvent;
        CompletableFuture<PooledBoltConnection> pendingAcquisition;
        PooledBoltConnectionSource pooledBoltConnectionSource = this;
        synchronized (pooledBoltConnectionSource) {
            entry.lastUsedTimestamp = this.clock.millis();
            pendingAcquisition = this.pendingAcquisitions.poll();
            if (pendingAcquisition == null) {
                entry.available = true;
            }
        }
        if (pendingAcquisition != null && pendingAcquisition.complete(new PooledBoltConnection(entry.connection, this, () -> this.lambda$release$31(entry, inUseEvent = this.metricsListener.createListenerEvent()), () -> {
            this.purge(entry);
            this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
        }))) {
            this.metricsListener.afterConnectionCreated(this.poolId, inUseEvent);
        }
        this.log.log(System.Logger.Level.DEBUG, "Connection released to the pool.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purge(ConnectionEntry entry) {
        PooledBoltConnectionSource pooledBoltConnectionSource = this;
        synchronized (pooledBoltConnectionSource) {
            this.pooledConnectionEntries.remove(entry);
        }
        this.metricsListener.afterClosed(this.poolId);
        entry.connection.close();
        this.log.log(System.Logger.Level.DEBUG, "Connection purged from the pool.");
    }

    public synchronized void onExpired() {
        long now = this.clock.millis();
        this.minAuthTimestamp = Math.max(this.minAuthTimestamp, now);
    }

    private /* synthetic */ void lambda$release$31(ConnectionEntry entry, ListenerEvent inUseEvent) {
        this.release(entry);
        this.metricsListener.afterConnectionReleased(this.poolId, inUseEvent);
    }

    private record ConnectionEntryWithMetadata(ConnectionEntry connectionEntry, boolean reauthNeeded) {
    }

    private static class ConnectionEntry {
        private BoltConnection connection;
        private boolean available;
        private long createdTimestamp;
        private long lastUsedTimestamp;

        private ConnectionEntry() {
        }
    }

    private record SecurityPlanAndAuthToken(SecurityPlan securityPlan, AuthToken authToken) {
    }
}

