/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

public class Restarter {
    private MuleProcessController mule;
    private File muleHome;
    private Log log;

    public Restarter(MuleProcessController mule, File muleHome, Log log) {
        this.mule = mule;
        this.muleHome = muleHome;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        if (null == this.muleHome) {
            throw new MojoFailureException("MULE_HOME is not set");
        }
        if (!this.muleHome.exists()) {
            throw new MojoFailureException("Couldn't find MULE_HOME directory at: " + this.muleHome);
        }
        this.log.info((CharSequence)("MULE_HOME is set to: " + this.muleHome));
        if (!this.mule.isRunning()) {
            throw new MojoFailureException("Mule ESB is not running");
        }
        try {
            this.log.debug((CharSequence)"Retarting Mule ESB ...");
            this.mule.restart(new String[0]);
            this.log.info((CharSequence)"Mule ESB restarted.");
        }
        catch (MuleControllerException e) {
            throw new MojoFailureException("Couldn't restart Mule ESB.");
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't restart Mule ESB.");
        }
    }
}

