/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.Undeployer;

@Mojo(name="clusterUndeploy", requiresProject=true, defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class ClusterUndeployMojo
extends AbstractMojo {
    @Component
    private MavenProject mavenProject;
    @Parameter(defaultValue="2", readonly=true, required=true)
    private Integer clusterSize;
    @Parameter(readonly=true, property="mule.version")
    private String muleVersion;

    public void execute() throws MojoExecutionException, MojoFailureException {
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        File[] muleHomes = new File[this.clusterSize.intValue()];
        for (int i = 0; i < this.clusterSize; ++i) {
            muleHomes[i] = new File(this.mavenProject.getBasedir() + "/target/mule" + i, "mule-enterprise-standalone-" + this.muleVersion);
            controllers.add(new MuleProcessController(muleHomes[i].getAbsolutePath()));
            if (muleHomes[i].exists()) continue;
            throw new MojoFailureException(muleHomes[i].getAbsolutePath() + "directory does not exist.");
        }
        new Undeployer(controllers, this.getLog()).execute();
    }
}

