/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.mule.test.infrastructure.process.MuleControllerException;
import org.mule.test.infrastructure.process.MuleProcessController;

public class ClusterStopper {
    private List<MuleProcessController> mules;
    private File[] muleHomes;
    private Log log;

    public ClusterStopper(List<MuleProcessController> mules, File[] muleHomes, Log log) {
        this.mules = mules;
        this.muleHomes = muleHomes;
        this.log = log;
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        int i = 0;
        for (MuleProcessController m : this.mules) {
            if (null == this.muleHomes[i]) {
                throw new MojoFailureException("MULE_HOME is not set");
            }
            if (!this.muleHomes[i].exists()) {
                this.log.error((CharSequence)("Couldn't find MULE_HOME directory at: " + this.muleHomes[i]));
                throw new MojoFailureException("Configuration variable MULE_HOME was not set.");
            }
            this.log.info((CharSequence)("MULE_HOME is set to: " + this.muleHomes[i]));
            if (!m.isRunning()) {
                this.log.error((CharSequence)"Mule ESB is not running.");
                throw new MojoFailureException("Mule ESB is not running.");
            }
            try {
                this.log.debug((CharSequence)"Stopping Mule ESB ...");
                m.stop(new String[0]);
                this.log.info((CharSequence)"Mule ESB stopped.");
            }
            catch (MuleControllerException e) {
                throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually.", (Exception)((Object)e));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error stopping Mule ESB. Please stop it manually.", e);
            }
        }
    }
}

