/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.muleesb;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.archiver.manager.ArchiverManager;
import org.codehaus.plexus.archiver.manager.NoSuchArchiverException;
import org.mule.test.infrastructure.process.MuleProcessController;
import org.mule.tools.muleesb.AbstractMuleMojo;
import org.mule.tools.muleesb.ArtifactDescription;
import org.mule.tools.muleesb.ClusterConfigurator;
import org.mule.tools.muleesb.ClusterDeployer;

@Mojo(name="clusterDeploy", requiresProject=false, defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public class ClusterDeployMojo
extends AbstractMuleMojo {
    private static final long DEFAULT_POLLING_DELAY = 1000L;
    @Component
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    @Component
    private ArtifactMetadataSource source;
    @Component
    protected ArchiverManager archiverManager;
    @Parameter(defaultValue="2", readonly=true, required=true)
    private Integer clusterSize;
    @Parameter(readonly=true)
    private ArtifactDescription muleDistribution;
    @Parameter(readonly=true, property="mule.version")
    private String muleVersion;
    @Parameter(property="mule.applications", required=true)
    private List<File> applications;
    @Parameter(property="mule.deployment.timeout", defaultValue="60000", required=true)
    private Long deploymentTimeout;
    @Parameter(property="mule.arguments", required=false)
    private String[] arguments;
    @Parameter
    private List<File> libs = new ArrayList<File>();

    @Override
    public void doExecute() throws MojoExecutionException, MojoFailureException {
        if (this.muleDistribution == null) {
            this.muleDistribution = new ArtifactDescription("com.mulesoft.muleesb.distributions", "mule-ee-distribution-standalone", this.muleVersion, "tar.gz");
            this.getLog().info((CharSequence)("muleDistribution not set, using default artifact: " + this.muleDistribution));
        }
        this.validate();
        File buildDirectory = new File(this.mavenProject.getBuild().getDirectory());
        this.installMules(this.muleDistribution, buildDirectory);
        LinkedList<MuleProcessController> controllers = new LinkedList<MuleProcessController>();
        File[] muleHomes = new File[this.clusterSize.intValue()];
        for (int i = 0; i < this.clusterSize; ++i) {
            muleHomes[i] = new File(this.mavenProject.getBuild().getDirectory() + "/mule" + i, "mule-enterprise-standalone-" + this.muleDistribution.getVersion());
            controllers.add(new MuleProcessController(muleHomes[i].getAbsolutePath(), this.timeout));
            this.validateEnterpriseVersion(muleHomes[i]);
        }
        ClusterConfigurator configurator = new ClusterConfigurator();
        if (null != this.script) {
            this.executeGroovyScript();
        }
        new ClusterDeployer(muleHomes, controllers, this.getLog(), this.applications, this.deploymentTimeout, this.arguments, 1000L, configurator).addLibraries(this.libs).execute();
    }

    private void validateEnterpriseVersion(File home) throws MojoFailureException {
        Scanner scanner = null;
        try {
            scanner = new Scanner(new File(home, "LICENSE.txt"));
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Cannot create cluster in Community Edition.\nCannot find license file in: " + new File(home, "LICENSE.txt").getAbsolutePath());
        }
        while (scanner.hasNextLine()) {
            if (!scanner.nextLine().contains("CPAL")) continue;
            throw new MojoFailureException("Cannot create cluster in Community Edition.");
        }
    }

    private void validate() throws MojoFailureException {
        this.verify(this.muleDistribution != null, "Mule ESB artifact description does not exist.");
        this.verifyNotNull(this.muleDistribution.getGroupId(), "groupId");
        this.verifyNotNull(this.muleDistribution.getArtifactId(), "artifactId");
        this.verifyNotNull(this.muleDistribution.getVersion(), "version");
        this.verifyNotNull(this.muleDistribution.getType(), "type");
    }

    private void installMules(ArtifactDescription muleDistribution, File buildDirectory) throws MojoExecutionException, MojoFailureException {
        for (int i = 0; i < this.clusterSize; ++i) {
            File destDir = new File(buildDirectory, "/mule" + i);
            destDir.mkdir();
            this.installMule(muleDistribution, destDir);
        }
    }

    private void installMule(ArtifactDescription muleDistribution, File destDir) throws MojoExecutionException, MojoFailureException {
        File src = this.getDependency(muleDistribution);
        this.getLog().info((CharSequence)("Copying " + src.getAbsolutePath() + " to " + destDir.getAbsolutePath()));
        this.extract(src, destDir, muleDistribution.getType());
    }

    private void extract(File src, File dest, String type) throws MojoExecutionException, MojoFailureException {
        try {
            UnArchiver unArchiver = this.getArchiver(type);
            unArchiver.setSourceFile(src);
            unArchiver.setDestDirectory(dest);
            unArchiver.extract();
        }
        catch (ArchiverException e) {
            throw new MojoExecutionException("Couldn't extract file " + src + " to " + dest);
        }
        catch (Exception e) {
            throw new MojoFailureException("Couldn't extract file " + src + " to " + dest);
        }
    }

    private UnArchiver getArchiver(String type) throws MojoExecutionException {
        UnArchiver unArchiver;
        try {
            unArchiver = this.archiverManager.getUnArchiver(type);
            this.getLog().debug((CharSequence)("Found unArchiver by extension: " + unArchiver));
        }
        catch (NoSuchArchiverException e) {
            throw new MojoExecutionException("Couldn't find archiver for type: " + type);
        }
        return unArchiver;
    }

    private void verifyNotNull(String value, String name) throws MojoFailureException {
        this.verify(StringUtils.isNotEmpty((String)value), "muleDistribution." + name + " cannot be empty.");
    }

    private void verify(boolean exists, String message) throws MojoFailureException {
        if (!exists) {
            throw new MojoFailureException(message);
        }
    }
}

