/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.mortbay.jetty.plus.naming.EnvEntry;
import org.mortbay.jetty.plus.naming.Link;
import org.mortbay.jetty.plus.naming.NamingEntry;
import org.mortbay.jetty.plus.naming.NamingEntryUtil;
import org.mortbay.jetty.plus.naming.Transaction;
import org.mortbay.jetty.plus.webapp.AbstractConfiguration;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.log.Log;
import org.mortbay.naming.NamingUtil;

public class Configuration
extends AbstractConfiguration {
    private Integer _key;

    public void bindEnvEntry(String name, Object value) throws Exception {
        InitialContext ic = null;
        boolean bound = false;
        ic = new InitialContext();
        try {
            NamingEntry ne = (NamingEntry)ic.lookup("java:comp/env/" + NamingEntryUtil.makeNamingEntryName(ic.getNameParser(""), name));
            if (ne != null && ne instanceof EnvEntry) {
                EnvEntry ee = (EnvEntry)ne;
                bound = ee.isOverrideWebXml();
            }
        }
        catch (NameNotFoundException e) {
            bound = false;
        }
        if (!bound) {
            Context envCtx = (Context)ic.lookup("java:comp/env");
            NamingUtil.bind((Context)envCtx, (String)name, (Object)value);
        }
    }

    public void bindResourceRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    public void bindResourceEnvRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    public void bindMessageDestinationRef(String name, Class typeClass) throws Exception {
        this.bindEntry(name, typeClass);
    }

    public void bindUserTransaction() throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            Log.info((String)"No Transaction manager found - if your webapp requires one, please configure one.");
        }
    }

    public void configureClassLoader() throws Exception {
        super.configureClassLoader();
    }

    public void configureDefaults() throws Exception {
        super.configureDefaults();
    }

    public void configureWebApp() throws Exception {
        super.configureWebApp();
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.lockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
    }

    public void deconfigureWebApp() throws Exception {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getWebAppContext().getClassLoader());
        this.unlockCompEnv();
        Thread.currentThread().setContextClassLoader(oldLoader);
        super.deconfigureWebApp();
    }

    protected void lockCompEnv() throws Exception {
        Random random = new Random();
        this._key = new Integer(random.nextInt());
        InitialContext context = new InitialContext();
        Context compCtx = (Context)context.lookup("java:comp");
        compCtx.addToEnvironment("org.mortbay.jndi.lock", this._key);
    }

    protected void unlockCompEnv() throws Exception {
        if (this._key != null) {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.mortbay.jndi.unlock", this._key);
        }
    }

    public void parseAnnotations() throws Exception {
    }

    private void bindEntry(String name, Class typeClass) throws Exception {
        String nameInEnvironment = name;
        boolean bound = false;
        WebAppContext scope = this.getWebAppContext();
        NamingEntry ne = NamingEntryUtil.lookupNamingEntry(scope, name);
        if (ne != null && ne instanceof Link) {
            nameInEnvironment = (String)((Link)ne).getObjectToBind();
            Link l = (Link)ne;
        }
        if (bound = NamingEntryUtil.bindToENC(scope = this.getWebAppContext(), name, nameInEnvironment)) {
            return;
        }
        scope = this.getWebAppContext().getServer();
        bound = NamingEntryUtil.bindToENC(scope, name, nameInEnvironment);
        if (bound) {
            return;
        }
        bound = NamingEntryUtil.bindToENC(null, name, nameInEnvironment);
        if (bound) {
            return;
        }
        nameInEnvironment = typeClass.getName() + "/default";
        NamingEntry defaultNE = NamingEntryUtil.lookupNamingEntry(this.getWebAppContext().getServer(), nameInEnvironment);
        if (defaultNE == null) {
            defaultNE = NamingEntryUtil.lookupNamingEntry(null, nameInEnvironment);
        }
        if (defaultNE == null) {
            throw new IllegalStateException("Nothing to bind for name " + nameInEnvironment);
        }
        defaultNE.bindToENC(name);
    }
}

