/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.ajp;

import java.io.IOException;
import org.mortbay.io.EndPoint;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.ajp.Ajp13Connection;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.log.Log;

public class Ajp13SocketConnector
extends SocketConnector {
    static String __secretWord = null;
    static boolean __allowShutdown = false;

    public Ajp13SocketConnector() {
        super.setHeaderBufferSize(8185);
        super.setRequestBufferSize(8185);
        super.setResponseBufferSize(8185);
        super.setMaxIdleTime(900000);
    }

    protected void doStart() throws Exception {
        Log.info((String)"AJP13 is not a secure protocol. Please protect port {}", (Object)Integer.toString(this.getPort()));
        super.doStart();
    }

    public void customize(EndPoint endpoint, Request request) throws IOException {
        super.customize(endpoint, request);
        if (request.isSecure()) {
            request.setScheme("https");
        }
    }

    protected HttpConnection newHttpConnection(EndPoint endpoint) {
        return new Ajp13Connection((Connector)this, endpoint, this.getServer());
    }

    public boolean isConfidential(Request request) {
        throw new UnsupportedOperationException();
    }

    public boolean isIntegral(Request request) {
        throw new UnsupportedOperationException();
    }

    public void setHeaderBufferSize(int headerBufferSize) {
        Log.debug((String)"IGNORED");
    }

    public void setRequestBufferSize(int requestBufferSize) {
        Log.debug((String)"IGNORED");
    }

    public void setResponseBufferSize(int responseBufferSize) {
        Log.debug((String)"IGNORED");
    }

    public void setAllowShutdown(boolean allowShutdown) {
        Log.warn((String)("AJP13: Shutdown Request is: " + allowShutdown));
        __allowShutdown = allowShutdown;
    }

    public void setSecretWord(String secretWord) {
        Log.warn((String)("AJP13: Shutdown Request secret word is : " + secretWord));
        __secretWord = secretWord;
    }
}

