/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.mongodb.internal.operation.CommandOperationHelper;
import com.mongodb.lang.Nullable;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;

final class DropSearchIndexOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "dropSearchIndex";
    private final String indexName;

    DropSearchIndexOperation(MongoNamespace namespace, String indexName) {
        super(namespace);
        this.indexName = indexName;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    <E extends Throwable> void swallowOrThrow(@Nullable E mongoExecutionException) throws E {
        if (mongoExecutionException != null && !CommandOperationHelper.isNamespaceError(mongoExecutionException)) {
            throw mongoExecutionException;
        }
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(this.getCommandName(), (BsonValue)new BsonString(this.getNamespace().getCollectionName())).append("name", (BsonValue)new BsonString(this.indexName));
    }
}

