/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ServerAddress;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterId;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.event.ServerDescriptionChangedEvent;
import com.mongodb.internal.TimeoutContext;
import com.mongodb.internal.async.SingleResultCallback;
import com.mongodb.internal.connection.ClientMetadata;
import com.mongodb.internal.connection.ClusterClock;
import com.mongodb.internal.connection.OperationContext;
import com.mongodb.internal.connection.Server;
import com.mongodb.internal.connection.ServerTuple;
import com.mongodb.internal.time.Timeout;
import com.mongodb.lang.Nullable;
import com.mongodb.selector.ServerSelector;
import java.io.Closeable;

public interface Cluster
extends Closeable {
    public ClusterSettings getSettings();

    public ClusterId getClusterId();

    public ServersSnapshot getServersSnapshot(Timeout var1, TimeoutContext var2);

    public ClusterDescription getCurrentDescription();

    public ClusterClock getClock();

    public ClientMetadata getClientMetadata();

    public ServerTuple selectServer(ServerSelector var1, OperationContext var2);

    public void selectServerAsync(ServerSelector var1, OperationContext var2, SingleResultCallback<ServerTuple> var3);

    @Override
    public void close();

    public boolean isClosed();

    public void withLock(Runnable var1);

    public void onChange(ServerDescriptionChangedEvent var1);

    @ThreadSafe
    public static interface ServersSnapshot {
        @Nullable
        public Server getServer(ServerAddress var1);

        default public boolean containsServer(ServerAddress serverAddress) {
            return this.getServer(serverAddress) != null;
        }
    }
}

