/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.net.MediaType;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.net.BindException;
import java.util.List;
import org.mockserver.client.serialization.PortBindingSerializer;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.mock.action.ActionHandler;
import org.mockserver.mockserver.MockServer;
import org.mockserver.mockserver.NettyResponseWriter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.PortBinding;
import org.mockserver.responsewriter.ResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MockServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private HttpStateHandler httpStateHandler;
    private PortBindingSerializer portBindingSerializer = new PortBindingSerializer();
    private MockServer server;
    private ActionHandler actionHandler;

    public MockServerHandler(MockServer server, HttpStateHandler httpStateHandler) {
        super(false);
        this.server = server;
        this.httpStateHandler = httpStateHandler;
        this.actionHandler = new ActionHandler(httpStateHandler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        block10: {
            NettyResponseWriter responseWriter = new NettyResponseWriter(ctx);
            try {
                if (this.httpStateHandler.handle(request, (ResponseWriter)responseWriter, false)) break block10;
                if (request.matches("PUT", "/status")) {
                    responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(this.server.getPorts())), "application/json");
                    break block10;
                }
                if (request.matches("PUT", "/bind")) {
                    PortBinding requestedPortBindings = this.portBindingSerializer.deserialize(request.getBodyAsString());
                    try {
                        List<Integer> actualPortBindings = this.server.bindToPorts(requestedPortBindings.getPorts());
                        responseWriter.writeResponse(request, HttpResponseStatus.OK, this.portBindingSerializer.serialize(PortBinding.portBinding(actualPortBindings)), "application/json");
                        break block10;
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof BindException) {
                            responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, e.getMessage() + " port already in use", MediaType.create((String)"text", (String)"plain").toString());
                            break block10;
                        }
                        throw e;
                    }
                }
                if (request.matches("PUT", "/stop")) {
                    ctx.writeAndFlush((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.OK.code())));
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            MockServerHandler.this.server.stop();
                        }
                    }).start();
                } else {
                    this.actionHandler.processAction(request, (ResponseWriter)responseWriter, ctx);
                }
            }
            catch (IllegalArgumentException iae) {
                this.logger.error("Exception processing " + request, (Throwable)iae);
                responseWriter.writeResponse(request, HttpResponseStatus.BAD_REQUEST, iae.getMessage(), MediaType.create((String)"text", (String)"plain").toString());
            }
            catch (Exception e) {
                this.logger.error("Exception processing " + request, (Throwable)e);
                responseWriter.writeResponse(request, HttpResponse.response().withStatusCode(Integer.valueOf(HttpResponseStatus.BAD_REQUEST.code())).withBody(e.getMessage()));
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (!ExceptionHandler.shouldIgnoreException(cause)) {
            this.logger.warn("Exception caught by " + this.server.getClass() + " handler -> closing pipeline " + ctx.channel(), cause);
        }
        ExceptionHandler.closeOnFlush(ctx.channel());
    }
}

