/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.http;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.filters.LogFilter;
import org.mockserver.proxy.Proxy;
import org.mockserver.proxy.http.HttpProxyUnificationHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpProxy
implements Proxy {
    private static final Logger logger = LoggerFactory.getLogger(HttpProxy.class);
    private final SettableFuture<String> hasStarted = SettableFuture.create();
    private final LogFilter logFilter = new LogFilter();
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private final Integer port;
    private static ProxySelector previousProxySelector;

    public HttpProxy(final Integer port) {
        if (port == null) {
            throw new IllegalArgumentException("Port must not be null");
        }
        this.port = port;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(HttpProxy.this.bossGroup, HttpProxy.this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childHandler((ChannelHandler)new HttpProxyUnificationHandler()).childAttr(Proxy.HTTP_PROXY, (Object)HttpProxy.this).childAttr(Proxy.REMOTE_SOCKET, (Object)new InetSocketAddress(port)).childAttr(Proxy.LOG_FILTER, (Object)HttpProxy.this.logFilter).bind(port.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            if (future.isSuccess()) {
                                HttpProxy.this.hasStarted.set((Object)"STARTED");
                                HttpProxy.this.proxyStarted(port);
                            } else {
                                HttpProxy.this.hasStarted.setException(future.cause());
                            }
                        }
                    }).channel().closeFuture().sync();
                }
                catch (Exception ie) {
                    logger.error("Exception while running proxy channels", (Throwable)ie);
                }
                finally {
                    HttpProxy.this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                    HttpProxy.this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                }
            }
        }).start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            logger.debug("Exception while waiting for proxy to complete starting up", (Throwable)e);
        }
    }

    @Override
    public void stop() {
        try {
            this.proxyStopping();
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (Exception ie) {
            logger.trace("Exception while waiting for the proxy to stop", (Throwable)ie);
        }
    }

    @Override
    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                logger.trace("Exception while waiting for the proxy to confirm running status", (Throwable)e);
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }

    public Integer getPort() {
        return this.port;
    }

    private static ProxySelector createProxySelector(final String host, final int port) {
        return new ProxySelector(){

            @Override
            public List<java.net.Proxy> select(URI uri) {
                return Arrays.asList(new java.net.Proxy(Proxy.Type.SOCKS, new InetSocketAddress(host, port)), new java.net.Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)));
            }

            @Override
            public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                logger.error("Connection could not be established to proxy at socket [" + sa + "]", (Throwable)ioe);
            }
        };
    }

    protected void proxyStarted(Integer port) {
        ConfigurationProperties.proxyPort((int)port);
        System.setProperty("proxySet", "true");
        System.setProperty("http.proxyHost", "127.0.0.1");
        System.setProperty("http.proxyPort", port.toString());
    }

    protected void proxyStopping() {
        System.clearProperty("proxySet");
        System.clearProperty("socksProxyHost");
        System.clearProperty("socksProxyPort");
        System.clearProperty("http.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyHost");
        System.clearProperty("https.proxyPort");
    }
}

