/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.mockserver;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import org.mockserver.filters.LogFilter;
import org.mockserver.mock.MockServerMatcher;
import org.mockserver.mockserver.MockServerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer {
    public static final AttributeKey<LogFilter> LOG_FILTER = AttributeKey.valueOf((String)"SERVER_LOG_FILTER");
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final MockServerMatcher mockServerMatcher = new MockServerMatcher();
    private final LogFilter logFilter = new LogFilter();
    private final SettableFuture<String> hasStarted;
    private final EventLoopGroup bossGroup = new NioEventLoopGroup();
    private final EventLoopGroup workerGroup = new NioEventLoopGroup();
    private Channel channel;

    public MockServer(final Integer port) {
        if (port == null) {
            throw new IllegalStateException("You must specify a port");
        }
        this.hasStarted = SettableFuture.create();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (port == 0) {
                        MockServer.this.logger.info("MockServer starting up on a free port");
                    } else {
                        MockServer.this.logger.info("MockServer starting up on port: {}", (Object)port);
                    }
                    MockServer.this.channel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(MockServer.this.bossGroup, MockServer.this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)1024)).childHandler((ChannelHandler)new MockServerInitializer(MockServer.this.mockServerMatcher, MockServer.this, false)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).childAttr(LOG_FILTER, (Object)MockServer.this.logFilter).bind(port.intValue()).sync().channel();
                    MockServer.this.logger.info("MockServer successfully started on port: {}", (Object)((InetSocketAddress)MockServer.this.channel.localAddress()).getPort());
                    MockServer.this.hasStarted.set((Object)"STARTED");
                    MockServer.this.channel.closeFuture().sync();
                }
                catch (InterruptedException ie) {
                    MockServer.this.logger.error("MockServer receive InterruptedException", (Throwable)ie);
                }
                finally {
                    MockServer.this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                    MockServer.this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
                }
            }
        }).start();
        try {
            this.hasStarted.get();
        }
        catch (Exception e) {
            this.logger.debug("Exception while waiting for MockServer to complete starting up", (Throwable)e);
        }
    }

    public void stop() {
        try {
            this.bossGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.workerGroup.shutdownGracefully(0L, 1L, TimeUnit.MILLISECONDS);
            this.channel.close();
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (Exception ie) {
            this.logger.trace("Exception while stopping MockServer", (Throwable)ie);
        }
    }

    public boolean isRunning() {
        if (this.hasStarted.isDone()) {
            try {
                TimeUnit.MILLISECONDS.sleep(500L);
            }
            catch (InterruptedException e) {
                this.logger.trace("Exception while waiting for the proxy to confirm running status", (Throwable)e);
            }
            return !this.bossGroup.isShuttingDown() && !this.workerGroup.isShuttingDown();
        }
        return false;
    }

    public Integer getPort() {
        return ((InetSocketAddress)this.channel.localAddress()).getPort();
    }
}

