/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.templates.engine.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.mockserver.model.ObjectWithJsonToString;
import org.mockserver.model.Parameter;

public class HttpRequestTemplateObject
extends ObjectWithJsonToString {
    private String method = "";
    private String path = "";
    private Map<String, List<String>> queryStringParameters = new HashMap<String, List<String>>();
    private BodyDTO body = null;
    private Map<String, String> cookies = new HashMap<String, String>();
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private Boolean keepAlive = null;
    private Boolean secure = null;

    public HttpRequestTemplateObject(HttpRequest httpRequest) {
        if (httpRequest != null) {
            this.method = httpRequest.getMethod().getValue();
            this.path = httpRequest.getPath().getValue();
            for (Header header : httpRequest.getHeaderList()) {
                this.headers.put(header.getName().getValue(), Lists.transform(header.getValues(), (Function)new Function<NottableString, String>(){

                    public String apply(NottableString input) {
                        return input.getValue();
                    }
                }));
            }
            for (Cookie cookie : httpRequest.getCookieList()) {
                this.cookies.put(cookie.getName().getValue(), cookie.getValue().getValue());
            }
            for (Parameter parameter : httpRequest.getQueryStringParameterList()) {
                this.queryStringParameters.put(parameter.getName().getValue(), Lists.transform(parameter.getValues(), (Function)new Function<NottableString, String>(){

                    public String apply(NottableString input) {
                        return input.getValue();
                    }
                }));
            }
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, List<String>> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public Boolean getSecure() {
        return this.secure;
    }
}

