/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.BodyMatcher;
import org.mockserver.matchers.ExactStringMatcher;
import org.mockserver.matchers.StringToXmlDocumentParser;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.NottableString;
import org.xml.sax.SAXException;

public class XmlStringMatcher
extends BodyMatcher<NottableString> {
    private static final String[] excludedFields = new String[]{"mockServerLogger", "stringToXmlDocumentParser"};
    private final MockServerLogger mockServerLogger;
    private NottableString matcher = NottableString.string("THIS SHOULD NEVER MATCH");
    private StringToXmlDocumentParser stringToXmlDocumentParser = new StringToXmlDocumentParser();

    public XmlStringMatcher(MockServerLogger mockServerLogger, String matcher) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.matcher = NottableString.string(this.normaliseXmlString(matcher));
        }
        catch (Exception e) {
            mockServerLogger.error("Error while creating xml string matcher for [" + matcher + "]" + e.getMessage(), e);
        }
    }

    public XmlStringMatcher(MockServerLogger mockServerLogger, NottableString matcher) {
        this.mockServerLogger = mockServerLogger;
        try {
            this.matcher = this.normaliseXmlNottableString(matcher);
        }
        catch (Exception e) {
            mockServerLogger.error("Error while creating xml string matcher for [" + matcher + "]" + e.getMessage(), e);
        }
    }

    public String normaliseXmlString(final String input) throws ParserConfigurationException, SAXException, IOException, TransformerException {
        return this.stringToXmlDocumentParser.normaliseXmlString(input, new StringToXmlDocumentParser.ErrorLogger(){

            @Override
            public void logError(String matched, Exception exception) {
                XmlStringMatcher.this.mockServerLogger.error("SAXParseException while parsing [" + input + "]", exception);
            }
        });
    }

    public NottableString normaliseXmlNottableString(NottableString input) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        return NottableString.string(this.normaliseXmlString(input.getValue()), input.isNot());
    }

    public boolean matches(String matched) {
        return this.matches((HttpRequest)null, NottableString.string(matched));
    }

    @Override
    public boolean matches(HttpRequest context, NottableString matched) {
        boolean result = false;
        try {
            if (ExactStringMatcher.matches(this.matcher.getValue(), this.normaliseXmlString(matched.getValue()), false)) {
                result = true;
            }
        }
        catch (Exception e) {
            this.mockServerLogger.trace(context, "Error while matching xml string [" + this.matcher + "] against xml string [" + matched + "] assuming no match - " + e.getMessage(), new Object[0]);
        }
        if (!result) {
            this.mockServerLogger.trace(context, "Failed to match [{}] with [{}]", matched, this.matcher);
        }
        return this.matcher.isNot() != (this.not != result);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

